/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TargetLabel {
    BLUE("Blue"),
    GREEN("Green"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TargetLabel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TargetLabel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TargetLabel.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TargetLabel> knownValues() {
        return Stream.of(TargetLabel.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

