/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.AutoScalingGroupNameListCopier;
import software.amazon.awssdk.services.codedeploy.model.EC2TagFilter;
import software.amazon.awssdk.services.codedeploy.model.EC2TagFilterListCopier;
import software.amazon.awssdk.services.codedeploy.model.EC2TagSet;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TargetInstances
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TargetInstances> {
    private static final SdkField<List<EC2TagFilter>> TAG_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TargetInstances.getter(TargetInstances::tagFilters)).setter(TargetInstances.setter(Builder::tagFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EC2TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AUTO_SCALING_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(TargetInstances.getter(TargetInstances::autoScalingGroups)).setter(TargetInstances.setter(Builder::autoScalingGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EC2TagSet> EC2_TAG_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(TargetInstances.getter(TargetInstances::ec2TagSet)).setter(TargetInstances.setter(Builder::ec2TagSet)).constructor(EC2TagSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2TagSet").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAG_FILTERS_FIELD, AUTO_SCALING_GROUPS_FIELD, EC2_TAG_SET_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<EC2TagFilter> tagFilters;
    private final List<String> autoScalingGroups;
    private final EC2TagSet ec2TagSet;

    private TargetInstances(BuilderImpl builder) {
        this.tagFilters = builder.tagFilters;
        this.autoScalingGroups = builder.autoScalingGroups;
        this.ec2TagSet = builder.ec2TagSet;
    }

    public List<EC2TagFilter> tagFilters() {
        return this.tagFilters;
    }

    public List<String> autoScalingGroups() {
        return this.autoScalingGroups;
    }

    public EC2TagSet ec2TagSet() {
        return this.ec2TagSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tagFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2TagSet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TargetInstances)) {
            return false;
        }
        TargetInstances other = (TargetInstances)obj;
        return Objects.equals(this.tagFilters(), other.tagFilters()) && Objects.equals(this.autoScalingGroups(), other.autoScalingGroups()) && Objects.equals(this.ec2TagSet(), other.ec2TagSet());
    }

    public String toString() {
        return ToString.builder((String)"TargetInstances").add("TagFilters", this.tagFilters()).add("AutoScalingGroups", this.autoScalingGroups()).add("Ec2TagSet", (Object)this.ec2TagSet()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tagFilters": {
                return Optional.ofNullable(clazz.cast(this.tagFilters()));
            }
            case "autoScalingGroups": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroups()));
            }
            case "ec2TagSet": {
                return Optional.ofNullable(clazz.cast(this.ec2TagSet()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TargetInstances, T> g) {
        return obj -> g.apply((TargetInstances)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EC2TagFilter> tagFilters = DefaultSdkAutoConstructList.getInstance();
        private List<String> autoScalingGroups = DefaultSdkAutoConstructList.getInstance();
        private EC2TagSet ec2TagSet;

        private BuilderImpl() {
        }

        private BuilderImpl(TargetInstances model) {
            this.tagFilters(model.tagFilters);
            this.autoScalingGroups(model.autoScalingGroups);
            this.ec2TagSet(model.ec2TagSet);
        }

        public final Collection<EC2TagFilter.Builder> getTagFilters() {
            return this.tagFilters != null ? (Collection)this.tagFilters.stream().map(EC2TagFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tagFilters(Collection<EC2TagFilter> tagFilters) {
            this.tagFilters = EC2TagFilterListCopier.copy(tagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(EC2TagFilter ... tagFilters) {
            this.tagFilters(Arrays.asList(tagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagFilters(Consumer<EC2TagFilter.Builder> ... tagFilters) {
            this.tagFilters(Stream.of(tagFilters).map(c -> (EC2TagFilter)((EC2TagFilter.Builder)EC2TagFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTagFilters(Collection<EC2TagFilter.BuilderImpl> tagFilters) {
            this.tagFilters = EC2TagFilterListCopier.copyFromBuilder(tagFilters);
        }

        public final Collection<String> getAutoScalingGroups() {
            return this.autoScalingGroups;
        }

        @Override
        public final Builder autoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(String ... autoScalingGroups) {
            this.autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        public final void setAutoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
        }

        public final EC2TagSet.Builder getEc2TagSet() {
            return this.ec2TagSet != null ? this.ec2TagSet.toBuilder() : null;
        }

        @Override
        public final Builder ec2TagSet(EC2TagSet ec2TagSet) {
            this.ec2TagSet = ec2TagSet;
            return this;
        }

        public final void setEc2TagSet(EC2TagSet.BuilderImpl ec2TagSet) {
            this.ec2TagSet = ec2TagSet != null ? ec2TagSet.build() : null;
        }

        public TargetInstances build() {
            return new TargetInstances(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TargetInstances> {
        public Builder tagFilters(Collection<EC2TagFilter> var1);

        public Builder tagFilters(EC2TagFilter ... var1);

        public Builder tagFilters(Consumer<EC2TagFilter.Builder> ... var1);

        public Builder autoScalingGroups(Collection<String> var1);

        public Builder autoScalingGroups(String ... var1);

        public Builder ec2TagSet(EC2TagSet var1);

        default public Builder ec2TagSet(Consumer<EC2TagSet.Builder> ec2TagSet) {
            return this.ec2TagSet((EC2TagSet)((EC2TagSet.Builder)EC2TagSet.builder().applyMutation(ec2TagSet)).build());
        }
    }
}

