/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentOverview
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentOverview> {
    private static final SdkField<Long> PENDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DeploymentOverview.getter(DeploymentOverview::pending)).setter(DeploymentOverview.setter(Builder::pending)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pending").build()}).build();
    private static final SdkField<Long> IN_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DeploymentOverview.getter(DeploymentOverview::inProgress)).setter(DeploymentOverview.setter(Builder::inProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InProgress").build()}).build();
    private static final SdkField<Long> SUCCEEDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DeploymentOverview.getter(DeploymentOverview::succeeded)).setter(DeploymentOverview.setter(Builder::succeeded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Succeeded").build()}).build();
    private static final SdkField<Long> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DeploymentOverview.getter(DeploymentOverview::failed)).setter(DeploymentOverview.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build()}).build();
    private static final SdkField<Long> SKIPPED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DeploymentOverview.getter(DeploymentOverview::skipped)).setter(DeploymentOverview.setter(Builder::skipped)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Skipped").build()}).build();
    private static final SdkField<Long> READY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(DeploymentOverview.getter(DeploymentOverview::ready)).setter(DeploymentOverview.setter(Builder::ready)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ready").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PENDING_FIELD, IN_PROGRESS_FIELD, SUCCEEDED_FIELD, FAILED_FIELD, SKIPPED_FIELD, READY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long pending;
    private final Long inProgress;
    private final Long succeeded;
    private final Long failed;
    private final Long skipped;
    private final Long ready;

    private DeploymentOverview(BuilderImpl builder) {
        this.pending = builder.pending;
        this.inProgress = builder.inProgress;
        this.succeeded = builder.succeeded;
        this.failed = builder.failed;
        this.skipped = builder.skipped;
        this.ready = builder.ready;
    }

    public Long pending() {
        return this.pending;
    }

    public Long inProgress() {
        return this.inProgress;
    }

    public Long succeeded() {
        return this.succeeded;
    }

    public Long failed() {
        return this.failed;
    }

    public Long skipped() {
        return this.skipped;
    }

    public Long ready() {
        return this.ready;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pending());
        hashCode = 31 * hashCode + Objects.hashCode(this.inProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.succeeded());
        hashCode = 31 * hashCode + Objects.hashCode(this.failed());
        hashCode = 31 * hashCode + Objects.hashCode(this.skipped());
        hashCode = 31 * hashCode + Objects.hashCode(this.ready());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentOverview)) {
            return false;
        }
        DeploymentOverview other = (DeploymentOverview)obj;
        return Objects.equals(this.pending(), other.pending()) && Objects.equals(this.inProgress(), other.inProgress()) && Objects.equals(this.succeeded(), other.succeeded()) && Objects.equals(this.failed(), other.failed()) && Objects.equals(this.skipped(), other.skipped()) && Objects.equals(this.ready(), other.ready());
    }

    public String toString() {
        return ToString.builder((String)"DeploymentOverview").add("Pending", (Object)this.pending()).add("InProgress", (Object)this.inProgress()).add("Succeeded", (Object)this.succeeded()).add("Failed", (Object)this.failed()).add("Skipped", (Object)this.skipped()).add("Ready", (Object)this.ready()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Pending": {
                return Optional.ofNullable(clazz.cast(this.pending()));
            }
            case "InProgress": {
                return Optional.ofNullable(clazz.cast(this.inProgress()));
            }
            case "Succeeded": {
                return Optional.ofNullable(clazz.cast(this.succeeded()));
            }
            case "Failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
            case "Skipped": {
                return Optional.ofNullable(clazz.cast(this.skipped()));
            }
            case "Ready": {
                return Optional.ofNullable(clazz.cast(this.ready()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentOverview, T> g) {
        return obj -> g.apply((DeploymentOverview)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long pending;
        private Long inProgress;
        private Long succeeded;
        private Long failed;
        private Long skipped;
        private Long ready;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentOverview model) {
            this.pending(model.pending);
            this.inProgress(model.inProgress);
            this.succeeded(model.succeeded);
            this.failed(model.failed);
            this.skipped(model.skipped);
            this.ready(model.ready);
        }

        public final Long getPending() {
            return this.pending;
        }

        @Override
        public final Builder pending(Long pending) {
            this.pending = pending;
            return this;
        }

        public final void setPending(Long pending) {
            this.pending = pending;
        }

        public final Long getInProgress() {
            return this.inProgress;
        }

        @Override
        public final Builder inProgress(Long inProgress) {
            this.inProgress = inProgress;
            return this;
        }

        public final void setInProgress(Long inProgress) {
            this.inProgress = inProgress;
        }

        public final Long getSucceeded() {
            return this.succeeded;
        }

        @Override
        public final Builder succeeded(Long succeeded) {
            this.succeeded = succeeded;
            return this;
        }

        public final void setSucceeded(Long succeeded) {
            this.succeeded = succeeded;
        }

        public final Long getFailed() {
            return this.failed;
        }

        @Override
        public final Builder failed(Long failed) {
            this.failed = failed;
            return this;
        }

        public final void setFailed(Long failed) {
            this.failed = failed;
        }

        public final Long getSkipped() {
            return this.skipped;
        }

        @Override
        public final Builder skipped(Long skipped) {
            this.skipped = skipped;
            return this;
        }

        public final void setSkipped(Long skipped) {
            this.skipped = skipped;
        }

        public final Long getReady() {
            return this.ready;
        }

        @Override
        public final Builder ready(Long ready) {
            this.ready = ready;
            return this;
        }

        public final void setReady(Long ready) {
            this.ready = ready;
        }

        public DeploymentOverview build() {
            return new DeploymentOverview(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentOverview> {
        public Builder pending(Long var1);

        public Builder inProgress(Long var1);

        public Builder succeeded(Long var1);

        public Builder failed(Long var1);

        public Builder skipped(Long var1);

        public Builder ready(Long var1);
    }
}

