/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.AlarmConfiguration;
import software.amazon.awssdk.services.codedeploy.model.AutoRollbackConfiguration;
import software.amazon.awssdk.services.codedeploy.model.AutoScalingGroupNameListCopier;
import software.amazon.awssdk.services.codedeploy.model.BlueGreenDeploymentConfiguration;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStyle;
import software.amazon.awssdk.services.codedeploy.model.EC2TagFilter;
import software.amazon.awssdk.services.codedeploy.model.EC2TagFilterListCopier;
import software.amazon.awssdk.services.codedeploy.model.EC2TagSet;
import software.amazon.awssdk.services.codedeploy.model.ECSService;
import software.amazon.awssdk.services.codedeploy.model.ECSServiceListCopier;
import software.amazon.awssdk.services.codedeploy.model.LoadBalancerInfo;
import software.amazon.awssdk.services.codedeploy.model.OnPremisesTagSet;
import software.amazon.awssdk.services.codedeploy.model.OutdatedInstancesStrategy;
import software.amazon.awssdk.services.codedeploy.model.TagFilter;
import software.amazon.awssdk.services.codedeploy.model.TagFilterListCopier;
import software.amazon.awssdk.services.codedeploy.model.TriggerConfig;
import software.amazon.awssdk.services.codedeploy.model.TriggerConfigListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDeploymentGroupRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, UpdateDeploymentGroupRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationName").getter(UpdateDeploymentGroupRequest.getter(UpdateDeploymentGroupRequest::applicationName)).setter(UpdateDeploymentGroupRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()}).build();
    private static final SdkField<String> CURRENT_DEPLOYMENT_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentDeploymentGroupName").getter(UpdateDeploymentGroupRequest.getter(UpdateDeploymentGroupRequest::currentDeploymentGroupName)).setter(UpdateDeploymentGroupRequest.setter(Builder::currentDeploymentGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentDeploymentGroupName").build()}).build();
    private static final SdkField<String> NEW_DEPLOYMENT_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("newDeploymentGroupName").getter(UpdateDeploymentGroupRequest.getter(UpdateDeploymentGroupRequest::newDeploymentGroupName)).setter(UpdateDeploymentGroupRequest.setter(Builder::newDeploymentGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newDeploymentGroupName").build()}).build();
    private static final SdkField<String> DEPLOYMENT_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentConfigName").getter(UpdateDeploymentGroupRequest.getter(UpdateDeploymentGroupRequest::deploymentConfigName)).setter(UpdateDeploymentGroupRequest.setter(Builder::deploymentConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigName").build()}).build();
    private static final SdkField<List<EC2TagFilter>> EC2_TAG_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ec2TagFilters").getter(UpdateDeploymentGroupRequest.getter(UpdateDeploymentGroupRequest::ec2TagFilters)).setter(UpdateDeploymentGroupRequest.setter(Builder::ec2TagFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2TagFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EC2TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TagFilter>> ON_PREMISES_INSTANCE_TAG_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("onPremisesInstanceTagFilters").getter(UpdateDeploymentGroupRequest.getter(UpdateDeploymentGroupRequest::onPremisesInstanceTagFilters)).setter(UpdateDeploymentGroupRequest.setter(Builder::onPremisesInstanceTagFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onPremisesInstanceTagFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AUTO_SCALING_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("autoScalingGroups").getter(UpdateDeploymentGroupRequest.getter(UpdateDeploymentGroupRequest::autoScalingGroups)).setter(UpdateDeploymentGroupRequest.setter(Builder::autoScalingGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoScalingGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceRoleArn").getter(UpdateDeploymentGroupRequest.getter(UpdateDeploymentGroupRequest::serviceRoleArn)).setter(UpdateDeploymentGroupRequest.setter(Builder::serviceRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceRoleArn").build()}).build();
    private static final SdkField<List<TriggerConfig>> TRIGGER_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("triggerConfigurations").getter(UpdateDeploymentGroupRequest.getter(UpdateDeploymentGroupRequest::triggerConfigurations)).setter(UpdateDeploymentGroupRequest.setter(Builder::triggerConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TriggerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AlarmConfiguration> ALARM_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("alarmConfiguration").getter(UpdateDeploymentGroupRequest.getter(UpdateDeploymentGroupRequest::alarmConfiguration)).setter(UpdateDeploymentGroupRequest.setter(Builder::alarmConfiguration)).constructor(AlarmConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmConfiguration").build()}).build();
    private static final SdkField<AutoRollbackConfiguration> AUTO_ROLLBACK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoRollbackConfiguration").getter(UpdateDeploymentGroupRequest.getter(UpdateDeploymentGroupRequest::autoRollbackConfiguration)).setter(UpdateDeploymentGroupRequest.setter(Builder::autoRollbackConfiguration)).constructor(AutoRollbackConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRollbackConfiguration").build()}).build();
    private static final SdkField<String> OUTDATED_INSTANCES_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outdatedInstancesStrategy").getter(UpdateDeploymentGroupRequest.getter(UpdateDeploymentGroupRequest::outdatedInstancesStrategyAsString)).setter(UpdateDeploymentGroupRequest.setter(Builder::outdatedInstancesStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outdatedInstancesStrategy").build()}).build();
    private static final SdkField<DeploymentStyle> DEPLOYMENT_STYLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deploymentStyle").getter(UpdateDeploymentGroupRequest.getter(UpdateDeploymentGroupRequest::deploymentStyle)).setter(UpdateDeploymentGroupRequest.setter(Builder::deploymentStyle)).constructor(DeploymentStyle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentStyle").build()}).build();
    private static final SdkField<BlueGreenDeploymentConfiguration> BLUE_GREEN_DEPLOYMENT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("blueGreenDeploymentConfiguration").getter(UpdateDeploymentGroupRequest.getter(UpdateDeploymentGroupRequest::blueGreenDeploymentConfiguration)).setter(UpdateDeploymentGroupRequest.setter(Builder::blueGreenDeploymentConfiguration)).constructor(BlueGreenDeploymentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueGreenDeploymentConfiguration").build()}).build();
    private static final SdkField<LoadBalancerInfo> LOAD_BALANCER_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("loadBalancerInfo").getter(UpdateDeploymentGroupRequest.getter(UpdateDeploymentGroupRequest::loadBalancerInfo)).setter(UpdateDeploymentGroupRequest.setter(Builder::loadBalancerInfo)).constructor(LoadBalancerInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loadBalancerInfo").build()}).build();
    private static final SdkField<EC2TagSet> EC2_TAG_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ec2TagSet").getter(UpdateDeploymentGroupRequest.getter(UpdateDeploymentGroupRequest::ec2TagSet)).setter(UpdateDeploymentGroupRequest.setter(Builder::ec2TagSet)).constructor(EC2TagSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2TagSet").build()}).build();
    private static final SdkField<List<ECSService>> ECS_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ecsServices").getter(UpdateDeploymentGroupRequest.getter(UpdateDeploymentGroupRequest::ecsServices)).setter(UpdateDeploymentGroupRequest.setter(Builder::ecsServices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsServices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ECSService::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OnPremisesTagSet> ON_PREMISES_TAG_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("onPremisesTagSet").getter(UpdateDeploymentGroupRequest.getter(UpdateDeploymentGroupRequest::onPremisesTagSet)).setter(UpdateDeploymentGroupRequest.setter(Builder::onPremisesTagSet)).constructor(OnPremisesTagSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onPremisesTagSet").build()}).build();
    private static final SdkField<Boolean> TERMINATION_HOOK_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("terminationHookEnabled").getter(UpdateDeploymentGroupRequest.getter(UpdateDeploymentGroupRequest::terminationHookEnabled)).setter(UpdateDeploymentGroupRequest.setter(Builder::terminationHookEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terminationHookEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, CURRENT_DEPLOYMENT_GROUP_NAME_FIELD, NEW_DEPLOYMENT_GROUP_NAME_FIELD, DEPLOYMENT_CONFIG_NAME_FIELD, EC2_TAG_FILTERS_FIELD, ON_PREMISES_INSTANCE_TAG_FILTERS_FIELD, AUTO_SCALING_GROUPS_FIELD, SERVICE_ROLE_ARN_FIELD, TRIGGER_CONFIGURATIONS_FIELD, ALARM_CONFIGURATION_FIELD, AUTO_ROLLBACK_CONFIGURATION_FIELD, OUTDATED_INSTANCES_STRATEGY_FIELD, DEPLOYMENT_STYLE_FIELD, BLUE_GREEN_DEPLOYMENT_CONFIGURATION_FIELD, LOAD_BALANCER_INFO_FIELD, EC2_TAG_SET_FIELD, ECS_SERVICES_FIELD, ON_PREMISES_TAG_SET_FIELD, TERMINATION_HOOK_ENABLED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDeploymentGroupRequest.memberNameToFieldInitializer();
    private final String applicationName;
    private final String currentDeploymentGroupName;
    private final String newDeploymentGroupName;
    private final String deploymentConfigName;
    private final List<EC2TagFilter> ec2TagFilters;
    private final List<TagFilter> onPremisesInstanceTagFilters;
    private final List<String> autoScalingGroups;
    private final String serviceRoleArn;
    private final List<TriggerConfig> triggerConfigurations;
    private final AlarmConfiguration alarmConfiguration;
    private final AutoRollbackConfiguration autoRollbackConfiguration;
    private final String outdatedInstancesStrategy;
    private final DeploymentStyle deploymentStyle;
    private final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;
    private final LoadBalancerInfo loadBalancerInfo;
    private final EC2TagSet ec2TagSet;
    private final List<ECSService> ecsServices;
    private final OnPremisesTagSet onPremisesTagSet;
    private final Boolean terminationHookEnabled;

    private UpdateDeploymentGroupRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.currentDeploymentGroupName = builder.currentDeploymentGroupName;
        this.newDeploymentGroupName = builder.newDeploymentGroupName;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.ec2TagFilters = builder.ec2TagFilters;
        this.onPremisesInstanceTagFilters = builder.onPremisesInstanceTagFilters;
        this.autoScalingGroups = builder.autoScalingGroups;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.triggerConfigurations = builder.triggerConfigurations;
        this.alarmConfiguration = builder.alarmConfiguration;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.outdatedInstancesStrategy = builder.outdatedInstancesStrategy;
        this.deploymentStyle = builder.deploymentStyle;
        this.blueGreenDeploymentConfiguration = builder.blueGreenDeploymentConfiguration;
        this.loadBalancerInfo = builder.loadBalancerInfo;
        this.ec2TagSet = builder.ec2TagSet;
        this.ecsServices = builder.ecsServices;
        this.onPremisesTagSet = builder.onPremisesTagSet;
        this.terminationHookEnabled = builder.terminationHookEnabled;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final String currentDeploymentGroupName() {
        return this.currentDeploymentGroupName;
    }

    public final String newDeploymentGroupName() {
        return this.newDeploymentGroupName;
    }

    public final String deploymentConfigName() {
        return this.deploymentConfigName;
    }

    public final boolean hasEc2TagFilters() {
        return this.ec2TagFilters != null && !(this.ec2TagFilters instanceof SdkAutoConstructList);
    }

    public final List<EC2TagFilter> ec2TagFilters() {
        return this.ec2TagFilters;
    }

    public final boolean hasOnPremisesInstanceTagFilters() {
        return this.onPremisesInstanceTagFilters != null && !(this.onPremisesInstanceTagFilters instanceof SdkAutoConstructList);
    }

    public final List<TagFilter> onPremisesInstanceTagFilters() {
        return this.onPremisesInstanceTagFilters;
    }

    public final boolean hasAutoScalingGroups() {
        return this.autoScalingGroups != null && !(this.autoScalingGroups instanceof SdkAutoConstructList);
    }

    public final List<String> autoScalingGroups() {
        return this.autoScalingGroups;
    }

    public final String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public final boolean hasTriggerConfigurations() {
        return this.triggerConfigurations != null && !(this.triggerConfigurations instanceof SdkAutoConstructList);
    }

    public final List<TriggerConfig> triggerConfigurations() {
        return this.triggerConfigurations;
    }

    public final AlarmConfiguration alarmConfiguration() {
        return this.alarmConfiguration;
    }

    public final AutoRollbackConfiguration autoRollbackConfiguration() {
        return this.autoRollbackConfiguration;
    }

    public final OutdatedInstancesStrategy outdatedInstancesStrategy() {
        return OutdatedInstancesStrategy.fromValue(this.outdatedInstancesStrategy);
    }

    public final String outdatedInstancesStrategyAsString() {
        return this.outdatedInstancesStrategy;
    }

    public final DeploymentStyle deploymentStyle() {
        return this.deploymentStyle;
    }

    public final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration() {
        return this.blueGreenDeploymentConfiguration;
    }

    public final LoadBalancerInfo loadBalancerInfo() {
        return this.loadBalancerInfo;
    }

    public final EC2TagSet ec2TagSet() {
        return this.ec2TagSet;
    }

    public final boolean hasEcsServices() {
        return this.ecsServices != null && !(this.ecsServices instanceof SdkAutoConstructList);
    }

    public final List<ECSService> ecsServices() {
        return this.ecsServices;
    }

    public final OnPremisesTagSet onPremisesTagSet() {
        return this.onPremisesTagSet;
    }

    public final Boolean terminationHookEnabled() {
        return this.terminationHookEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentDeploymentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.newDeploymentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEc2TagFilters() ? this.ec2TagFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOnPremisesInstanceTagFilters() ? this.onPremisesInstanceTagFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutoScalingGroups() ? this.autoScalingGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTriggerConfigurations() ? this.triggerConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.outdatedInstancesStrategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueGreenDeploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2TagSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEcsServices() ? this.ecsServices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.onPremisesTagSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationHookEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDeploymentGroupRequest)) {
            return false;
        }
        UpdateDeploymentGroupRequest other = (UpdateDeploymentGroupRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.currentDeploymentGroupName(), other.currentDeploymentGroupName()) && Objects.equals(this.newDeploymentGroupName(), other.newDeploymentGroupName()) && Objects.equals(this.deploymentConfigName(), other.deploymentConfigName()) && this.hasEc2TagFilters() == other.hasEc2TagFilters() && Objects.equals(this.ec2TagFilters(), other.ec2TagFilters()) && this.hasOnPremisesInstanceTagFilters() == other.hasOnPremisesInstanceTagFilters() && Objects.equals(this.onPremisesInstanceTagFilters(), other.onPremisesInstanceTagFilters()) && this.hasAutoScalingGroups() == other.hasAutoScalingGroups() && Objects.equals(this.autoScalingGroups(), other.autoScalingGroups()) && Objects.equals(this.serviceRoleArn(), other.serviceRoleArn()) && this.hasTriggerConfigurations() == other.hasTriggerConfigurations() && Objects.equals(this.triggerConfigurations(), other.triggerConfigurations()) && Objects.equals(this.alarmConfiguration(), other.alarmConfiguration()) && Objects.equals(this.autoRollbackConfiguration(), other.autoRollbackConfiguration()) && Objects.equals(this.outdatedInstancesStrategyAsString(), other.outdatedInstancesStrategyAsString()) && Objects.equals(this.deploymentStyle(), other.deploymentStyle()) && Objects.equals(this.blueGreenDeploymentConfiguration(), other.blueGreenDeploymentConfiguration()) && Objects.equals(this.loadBalancerInfo(), other.loadBalancerInfo()) && Objects.equals(this.ec2TagSet(), other.ec2TagSet()) && this.hasEcsServices() == other.hasEcsServices() && Objects.equals(this.ecsServices(), other.ecsServices()) && Objects.equals(this.onPremisesTagSet(), other.onPremisesTagSet()) && Objects.equals(this.terminationHookEnabled(), other.terminationHookEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDeploymentGroupRequest").add("ApplicationName", (Object)this.applicationName()).add("CurrentDeploymentGroupName", (Object)this.currentDeploymentGroupName()).add("NewDeploymentGroupName", (Object)this.newDeploymentGroupName()).add("DeploymentConfigName", (Object)this.deploymentConfigName()).add("Ec2TagFilters", this.hasEc2TagFilters() ? this.ec2TagFilters() : null).add("OnPremisesInstanceTagFilters", this.hasOnPremisesInstanceTagFilters() ? this.onPremisesInstanceTagFilters() : null).add("AutoScalingGroups", this.hasAutoScalingGroups() ? this.autoScalingGroups() : null).add("ServiceRoleArn", (Object)this.serviceRoleArn()).add("TriggerConfigurations", this.hasTriggerConfigurations() ? this.triggerConfigurations() : null).add("AlarmConfiguration", (Object)this.alarmConfiguration()).add("AutoRollbackConfiguration", (Object)this.autoRollbackConfiguration()).add("OutdatedInstancesStrategy", (Object)this.outdatedInstancesStrategyAsString()).add("DeploymentStyle", (Object)this.deploymentStyle()).add("BlueGreenDeploymentConfiguration", (Object)this.blueGreenDeploymentConfiguration()).add("LoadBalancerInfo", (Object)this.loadBalancerInfo()).add("Ec2TagSet", (Object)this.ec2TagSet()).add("EcsServices", this.hasEcsServices() ? this.ecsServices() : null).add("OnPremisesTagSet", (Object)this.onPremisesTagSet()).add("TerminationHookEnabled", (Object)this.terminationHookEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "currentDeploymentGroupName": {
                return Optional.ofNullable(clazz.cast(this.currentDeploymentGroupName()));
            }
            case "newDeploymentGroupName": {
                return Optional.ofNullable(clazz.cast(this.newDeploymentGroupName()));
            }
            case "deploymentConfigName": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfigName()));
            }
            case "ec2TagFilters": {
                return Optional.ofNullable(clazz.cast(this.ec2TagFilters()));
            }
            case "onPremisesInstanceTagFilters": {
                return Optional.ofNullable(clazz.cast(this.onPremisesInstanceTagFilters()));
            }
            case "autoScalingGroups": {
                return Optional.ofNullable(clazz.cast(this.autoScalingGroups()));
            }
            case "serviceRoleArn": {
                return Optional.ofNullable(clazz.cast(this.serviceRoleArn()));
            }
            case "triggerConfigurations": {
                return Optional.ofNullable(clazz.cast(this.triggerConfigurations()));
            }
            case "alarmConfiguration": {
                return Optional.ofNullable(clazz.cast(this.alarmConfiguration()));
            }
            case "autoRollbackConfiguration": {
                return Optional.ofNullable(clazz.cast(this.autoRollbackConfiguration()));
            }
            case "outdatedInstancesStrategy": {
                return Optional.ofNullable(clazz.cast(this.outdatedInstancesStrategyAsString()));
            }
            case "deploymentStyle": {
                return Optional.ofNullable(clazz.cast(this.deploymentStyle()));
            }
            case "blueGreenDeploymentConfiguration": {
                return Optional.ofNullable(clazz.cast(this.blueGreenDeploymentConfiguration()));
            }
            case "loadBalancerInfo": {
                return Optional.ofNullable(clazz.cast(this.loadBalancerInfo()));
            }
            case "ec2TagSet": {
                return Optional.ofNullable(clazz.cast(this.ec2TagSet()));
            }
            case "ecsServices": {
                return Optional.ofNullable(clazz.cast(this.ecsServices()));
            }
            case "onPremisesTagSet": {
                return Optional.ofNullable(clazz.cast(this.onPremisesTagSet()));
            }
            case "terminationHookEnabled": {
                return Optional.ofNullable(clazz.cast(this.terminationHookEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("applicationName", APPLICATION_NAME_FIELD);
        map.put("currentDeploymentGroupName", CURRENT_DEPLOYMENT_GROUP_NAME_FIELD);
        map.put("newDeploymentGroupName", NEW_DEPLOYMENT_GROUP_NAME_FIELD);
        map.put("deploymentConfigName", DEPLOYMENT_CONFIG_NAME_FIELD);
        map.put("ec2TagFilters", EC2_TAG_FILTERS_FIELD);
        map.put("onPremisesInstanceTagFilters", ON_PREMISES_INSTANCE_TAG_FILTERS_FIELD);
        map.put("autoScalingGroups", AUTO_SCALING_GROUPS_FIELD);
        map.put("serviceRoleArn", SERVICE_ROLE_ARN_FIELD);
        map.put("triggerConfigurations", TRIGGER_CONFIGURATIONS_FIELD);
        map.put("alarmConfiguration", ALARM_CONFIGURATION_FIELD);
        map.put("autoRollbackConfiguration", AUTO_ROLLBACK_CONFIGURATION_FIELD);
        map.put("outdatedInstancesStrategy", OUTDATED_INSTANCES_STRATEGY_FIELD);
        map.put("deploymentStyle", DEPLOYMENT_STYLE_FIELD);
        map.put("blueGreenDeploymentConfiguration", BLUE_GREEN_DEPLOYMENT_CONFIGURATION_FIELD);
        map.put("loadBalancerInfo", LOAD_BALANCER_INFO_FIELD);
        map.put("ec2TagSet", EC2_TAG_SET_FIELD);
        map.put("ecsServices", ECS_SERVICES_FIELD);
        map.put("onPremisesTagSet", ON_PREMISES_TAG_SET_FIELD);
        map.put("terminationHookEnabled", TERMINATION_HOOK_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDeploymentGroupRequest, T> g) {
        return obj -> g.apply((UpdateDeploymentGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String currentDeploymentGroupName;
        private String newDeploymentGroupName;
        private String deploymentConfigName;
        private List<EC2TagFilter> ec2TagFilters = DefaultSdkAutoConstructList.getInstance();
        private List<TagFilter> onPremisesInstanceTagFilters = DefaultSdkAutoConstructList.getInstance();
        private List<String> autoScalingGroups = DefaultSdkAutoConstructList.getInstance();
        private String serviceRoleArn;
        private List<TriggerConfig> triggerConfigurations = DefaultSdkAutoConstructList.getInstance();
        private AlarmConfiguration alarmConfiguration;
        private AutoRollbackConfiguration autoRollbackConfiguration;
        private String outdatedInstancesStrategy;
        private DeploymentStyle deploymentStyle;
        private BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;
        private LoadBalancerInfo loadBalancerInfo;
        private EC2TagSet ec2TagSet;
        private List<ECSService> ecsServices = DefaultSdkAutoConstructList.getInstance();
        private OnPremisesTagSet onPremisesTagSet;
        private Boolean terminationHookEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDeploymentGroupRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.currentDeploymentGroupName(model.currentDeploymentGroupName);
            this.newDeploymentGroupName(model.newDeploymentGroupName);
            this.deploymentConfigName(model.deploymentConfigName);
            this.ec2TagFilters(model.ec2TagFilters);
            this.onPremisesInstanceTagFilters(model.onPremisesInstanceTagFilters);
            this.autoScalingGroups(model.autoScalingGroups);
            this.serviceRoleArn(model.serviceRoleArn);
            this.triggerConfigurations(model.triggerConfigurations);
            this.alarmConfiguration(model.alarmConfiguration);
            this.autoRollbackConfiguration(model.autoRollbackConfiguration);
            this.outdatedInstancesStrategy(model.outdatedInstancesStrategy);
            this.deploymentStyle(model.deploymentStyle);
            this.blueGreenDeploymentConfiguration(model.blueGreenDeploymentConfiguration);
            this.loadBalancerInfo(model.loadBalancerInfo);
            this.ec2TagSet(model.ec2TagSet);
            this.ecsServices(model.ecsServices);
            this.onPremisesTagSet(model.onPremisesTagSet);
            this.terminationHookEnabled(model.terminationHookEnabled);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getCurrentDeploymentGroupName() {
            return this.currentDeploymentGroupName;
        }

        public final void setCurrentDeploymentGroupName(String currentDeploymentGroupName) {
            this.currentDeploymentGroupName = currentDeploymentGroupName;
        }

        @Override
        public final Builder currentDeploymentGroupName(String currentDeploymentGroupName) {
            this.currentDeploymentGroupName = currentDeploymentGroupName;
            return this;
        }

        public final String getNewDeploymentGroupName() {
            return this.newDeploymentGroupName;
        }

        public final void setNewDeploymentGroupName(String newDeploymentGroupName) {
            this.newDeploymentGroupName = newDeploymentGroupName;
        }

        @Override
        public final Builder newDeploymentGroupName(String newDeploymentGroupName) {
            this.newDeploymentGroupName = newDeploymentGroupName;
            return this;
        }

        public final String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final List<EC2TagFilter.Builder> getEc2TagFilters() {
            List<EC2TagFilter.Builder> result = EC2TagFilterListCopier.copyToBuilder(this.ec2TagFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEc2TagFilters(Collection<EC2TagFilter.BuilderImpl> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copyFromBuilder(ec2TagFilters);
        }

        @Override
        public final Builder ec2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copy(ec2TagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2TagFilters(EC2TagFilter ... ec2TagFilters) {
            this.ec2TagFilters(Arrays.asList(ec2TagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2TagFilters(Consumer<EC2TagFilter.Builder> ... ec2TagFilters) {
            this.ec2TagFilters(Stream.of(ec2TagFilters).map(c -> (EC2TagFilter)((EC2TagFilter.Builder)EC2TagFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TagFilter.Builder> getOnPremisesInstanceTagFilters() {
            List<TagFilter.Builder> result = TagFilterListCopier.copyToBuilder(this.onPremisesInstanceTagFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOnPremisesInstanceTagFilters(Collection<TagFilter.BuilderImpl> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copyFromBuilder(onPremisesInstanceTagFilters);
        }

        @Override
        public final Builder onPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copy(onPremisesInstanceTagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onPremisesInstanceTagFilters(TagFilter ... onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters(Arrays.asList(onPremisesInstanceTagFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onPremisesInstanceTagFilters(Consumer<TagFilter.Builder> ... onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters(Stream.of(onPremisesInstanceTagFilters).map(c -> (TagFilter)((TagFilter.Builder)TagFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAutoScalingGroups() {
            if (this.autoScalingGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.autoScalingGroups;
        }

        public final void setAutoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
        }

        @Override
        public final Builder autoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(String ... autoScalingGroups) {
            this.autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final List<TriggerConfig.Builder> getTriggerConfigurations() {
            List<TriggerConfig.Builder> result = TriggerConfigListCopier.copyToBuilder(this.triggerConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggerConfigurations(Collection<TriggerConfig.BuilderImpl> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copyFromBuilder(triggerConfigurations);
        }

        @Override
        public final Builder triggerConfigurations(Collection<TriggerConfig> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copy(triggerConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerConfigurations(TriggerConfig ... triggerConfigurations) {
            this.triggerConfigurations(Arrays.asList(triggerConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerConfigurations(Consumer<TriggerConfig.Builder> ... triggerConfigurations) {
            this.triggerConfigurations(Stream.of(triggerConfigurations).map(c -> (TriggerConfig)((TriggerConfig.Builder)TriggerConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AlarmConfiguration.Builder getAlarmConfiguration() {
            return this.alarmConfiguration != null ? this.alarmConfiguration.toBuilder() : null;
        }

        public final void setAlarmConfiguration(AlarmConfiguration.BuilderImpl alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration != null ? alarmConfiguration.build() : null;
        }

        @Override
        public final Builder alarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        public final AutoRollbackConfiguration.Builder getAutoRollbackConfiguration() {
            return this.autoRollbackConfiguration != null ? this.autoRollbackConfiguration.toBuilder() : null;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration.BuilderImpl autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration != null ? autoRollbackConfiguration.build() : null;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final String getOutdatedInstancesStrategy() {
            return this.outdatedInstancesStrategy;
        }

        public final void setOutdatedInstancesStrategy(String outdatedInstancesStrategy) {
            this.outdatedInstancesStrategy = outdatedInstancesStrategy;
        }

        @Override
        public final Builder outdatedInstancesStrategy(String outdatedInstancesStrategy) {
            this.outdatedInstancesStrategy = outdatedInstancesStrategy;
            return this;
        }

        @Override
        public final Builder outdatedInstancesStrategy(OutdatedInstancesStrategy outdatedInstancesStrategy) {
            this.outdatedInstancesStrategy(outdatedInstancesStrategy == null ? null : outdatedInstancesStrategy.toString());
            return this;
        }

        public final DeploymentStyle.Builder getDeploymentStyle() {
            return this.deploymentStyle != null ? this.deploymentStyle.toBuilder() : null;
        }

        public final void setDeploymentStyle(DeploymentStyle.BuilderImpl deploymentStyle) {
            this.deploymentStyle = deploymentStyle != null ? deploymentStyle.build() : null;
        }

        @Override
        public final Builder deploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
            return this;
        }

        public final BlueGreenDeploymentConfiguration.Builder getBlueGreenDeploymentConfiguration() {
            return this.blueGreenDeploymentConfiguration != null ? this.blueGreenDeploymentConfiguration.toBuilder() : null;
        }

        public final void setBlueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration.BuilderImpl blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration != null ? blueGreenDeploymentConfiguration.build() : null;
        }

        @Override
        public final Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
            return this;
        }

        public final LoadBalancerInfo.Builder getLoadBalancerInfo() {
            return this.loadBalancerInfo != null ? this.loadBalancerInfo.toBuilder() : null;
        }

        public final void setLoadBalancerInfo(LoadBalancerInfo.BuilderImpl loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo != null ? loadBalancerInfo.build() : null;
        }

        @Override
        public final Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
            return this;
        }

        public final EC2TagSet.Builder getEc2TagSet() {
            return this.ec2TagSet != null ? this.ec2TagSet.toBuilder() : null;
        }

        public final void setEc2TagSet(EC2TagSet.BuilderImpl ec2TagSet) {
            this.ec2TagSet = ec2TagSet != null ? ec2TagSet.build() : null;
        }

        @Override
        public final Builder ec2TagSet(EC2TagSet ec2TagSet) {
            this.ec2TagSet = ec2TagSet;
            return this;
        }

        public final List<ECSService.Builder> getEcsServices() {
            List<ECSService.Builder> result = ECSServiceListCopier.copyToBuilder(this.ecsServices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEcsServices(Collection<ECSService.BuilderImpl> ecsServices) {
            this.ecsServices = ECSServiceListCopier.copyFromBuilder(ecsServices);
        }

        @Override
        public final Builder ecsServices(Collection<ECSService> ecsServices) {
            this.ecsServices = ECSServiceListCopier.copy(ecsServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsServices(ECSService ... ecsServices) {
            this.ecsServices(Arrays.asList(ecsServices));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsServices(Consumer<ECSService.Builder> ... ecsServices) {
            this.ecsServices(Stream.of(ecsServices).map(c -> (ECSService)((ECSService.Builder)ECSService.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final OnPremisesTagSet.Builder getOnPremisesTagSet() {
            return this.onPremisesTagSet != null ? this.onPremisesTagSet.toBuilder() : null;
        }

        public final void setOnPremisesTagSet(OnPremisesTagSet.BuilderImpl onPremisesTagSet) {
            this.onPremisesTagSet = onPremisesTagSet != null ? onPremisesTagSet.build() : null;
        }

        @Override
        public final Builder onPremisesTagSet(OnPremisesTagSet onPremisesTagSet) {
            this.onPremisesTagSet = onPremisesTagSet;
            return this;
        }

        public final Boolean getTerminationHookEnabled() {
            return this.terminationHookEnabled;
        }

        public final void setTerminationHookEnabled(Boolean terminationHookEnabled) {
            this.terminationHookEnabled = terminationHookEnabled;
        }

        @Override
        public final Builder terminationHookEnabled(Boolean terminationHookEnabled) {
            this.terminationHookEnabled = terminationHookEnabled;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDeploymentGroupRequest build() {
            return new UpdateDeploymentGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeDeployRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDeploymentGroupRequest> {
        public Builder applicationName(String var1);

        public Builder currentDeploymentGroupName(String var1);

        public Builder newDeploymentGroupName(String var1);

        public Builder deploymentConfigName(String var1);

        public Builder ec2TagFilters(Collection<EC2TagFilter> var1);

        public Builder ec2TagFilters(EC2TagFilter ... var1);

        public Builder ec2TagFilters(Consumer<EC2TagFilter.Builder> ... var1);

        public Builder onPremisesInstanceTagFilters(Collection<TagFilter> var1);

        public Builder onPremisesInstanceTagFilters(TagFilter ... var1);

        public Builder onPremisesInstanceTagFilters(Consumer<TagFilter.Builder> ... var1);

        public Builder autoScalingGroups(Collection<String> var1);

        public Builder autoScalingGroups(String ... var1);

        public Builder serviceRoleArn(String var1);

        public Builder triggerConfigurations(Collection<TriggerConfig> var1);

        public Builder triggerConfigurations(TriggerConfig ... var1);

        public Builder triggerConfigurations(Consumer<TriggerConfig.Builder> ... var1);

        public Builder alarmConfiguration(AlarmConfiguration var1);

        default public Builder alarmConfiguration(Consumer<AlarmConfiguration.Builder> alarmConfiguration) {
            return this.alarmConfiguration((AlarmConfiguration)((AlarmConfiguration.Builder)AlarmConfiguration.builder().applyMutation(alarmConfiguration)).build());
        }

        public Builder autoRollbackConfiguration(AutoRollbackConfiguration var1);

        default public Builder autoRollbackConfiguration(Consumer<AutoRollbackConfiguration.Builder> autoRollbackConfiguration) {
            return this.autoRollbackConfiguration((AutoRollbackConfiguration)((AutoRollbackConfiguration.Builder)AutoRollbackConfiguration.builder().applyMutation(autoRollbackConfiguration)).build());
        }

        public Builder outdatedInstancesStrategy(String var1);

        public Builder outdatedInstancesStrategy(OutdatedInstancesStrategy var1);

        public Builder deploymentStyle(DeploymentStyle var1);

        default public Builder deploymentStyle(Consumer<DeploymentStyle.Builder> deploymentStyle) {
            return this.deploymentStyle((DeploymentStyle)((DeploymentStyle.Builder)DeploymentStyle.builder().applyMutation(deploymentStyle)).build());
        }

        public Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration var1);

        default public Builder blueGreenDeploymentConfiguration(Consumer<BlueGreenDeploymentConfiguration.Builder> blueGreenDeploymentConfiguration) {
            return this.blueGreenDeploymentConfiguration((BlueGreenDeploymentConfiguration)((BlueGreenDeploymentConfiguration.Builder)BlueGreenDeploymentConfiguration.builder().applyMutation(blueGreenDeploymentConfiguration)).build());
        }

        public Builder loadBalancerInfo(LoadBalancerInfo var1);

        default public Builder loadBalancerInfo(Consumer<LoadBalancerInfo.Builder> loadBalancerInfo) {
            return this.loadBalancerInfo((LoadBalancerInfo)((LoadBalancerInfo.Builder)LoadBalancerInfo.builder().applyMutation(loadBalancerInfo)).build());
        }

        public Builder ec2TagSet(EC2TagSet var1);

        default public Builder ec2TagSet(Consumer<EC2TagSet.Builder> ec2TagSet) {
            return this.ec2TagSet((EC2TagSet)((EC2TagSet.Builder)EC2TagSet.builder().applyMutation(ec2TagSet)).build());
        }

        public Builder ecsServices(Collection<ECSService> var1);

        public Builder ecsServices(ECSService ... var1);

        public Builder ecsServices(Consumer<ECSService.Builder> ... var1);

        public Builder onPremisesTagSet(OnPremisesTagSet var1);

        default public Builder onPremisesTagSet(Consumer<OnPremisesTagSet.Builder> onPremisesTagSet) {
            return this.onPremisesTagSet((OnPremisesTagSet)((OnPremisesTagSet.Builder)OnPremisesTagSet.builder().applyMutation(onPremisesTagSet)).build());
        }

        public Builder terminationHookEnabled(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

