/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum InstanceAction {
    TERMINATE("TERMINATE"),
    KEEP_ALIVE("KEEP_ALIVE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, InstanceAction> VALUE_MAP;
    private final String value;

    private InstanceAction(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static InstanceAction fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<InstanceAction> knownValues() {
        EnumSet<InstanceAction> knownValues = EnumSet.allOf(InstanceAction.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(InstanceAction.class, InstanceAction::toString);
    }
}

