/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.codedeploy.CodeDeployClient;
import software.amazon.awssdk.services.codedeploy.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentRequest;
import software.amazon.awssdk.services.codedeploy.model.GetDeploymentResponse;
import software.amazon.awssdk.services.codedeploy.waiters.CodeDeployWaiter;
import software.amazon.awssdk.services.codedeploy.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultCodeDeployWaiter
implements CodeDeployWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final CodeDeployClient client;
    private final AttributeMap managedResources;
    private final Waiter<GetDeploymentResponse> deploymentSuccessfulWaiter;

    private DefaultCodeDeployWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (CodeDeployClient)CodeDeployClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.deploymentSuccessfulWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetDeploymentResponse.class).acceptors(DefaultCodeDeployWaiter.deploymentSuccessfulWaiterAcceptors())).overrideConfiguration(DefaultCodeDeployWaiter.deploymentSuccessfulWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetDeploymentResponse> waitUntilDeploymentSuccessful(GetDeploymentRequest getDeploymentRequest) {
        return this.deploymentSuccessfulWaiter.run(() -> this.client.getDeployment(this.applyWaitersUserAgent(getDeploymentRequest)));
    }

    @Override
    public WaiterResponse<GetDeploymentResponse> waitUntilDeploymentSuccessful(GetDeploymentRequest getDeploymentRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.deploymentSuccessfulWaiter.run(() -> this.client.getDeployment(this.applyWaitersUserAgent(getDeploymentRequest)), DefaultCodeDeployWaiter.deploymentSuccessfulWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetDeploymentResponse>> deploymentSuccessfulWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetDeploymentResponse>> result = new ArrayList<WaiterAcceptor<? super GetDeploymentResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("deploymentInfo").field("status").value(), "Succeeded");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("deploymentInfo").field("status").value(), "Failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (deploymentInfo.status=Failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("deploymentInfo").field("status").value(), "Stopped");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (deploymentInfo.status=Stopped) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration deploymentSuccessfulWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(120);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static CodeDeployWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends CodeDeployRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CodeDeployRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements CodeDeployWaiter.Builder {
        private CodeDeployClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public CodeDeployWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public CodeDeployWaiter.Builder client(CodeDeployClient client) {
            this.client = client;
            return this;
        }

        @Override
        public CodeDeployWaiter build() {
            return new DefaultCodeDeployWaiter(this);
        }
    }
}

