/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.LambdaFunctionInfo;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEvent;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEventListCopier;
import software.amazon.awssdk.services.codedeploy.model.TargetStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LambdaTarget
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LambdaTarget> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentId").getter(LambdaTarget.getter(LambdaTarget::deploymentId)).setter(LambdaTarget.setter(Builder::deploymentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentId").build()}).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetId").getter(LambdaTarget.getter(LambdaTarget::targetId)).setter(LambdaTarget.setter(Builder::targetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetId").build()}).build();
    private static final SdkField<String> TARGET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetArn").getter(LambdaTarget.getter(LambdaTarget::targetArn)).setter(LambdaTarget.setter(Builder::targetArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(LambdaTarget.getter(LambdaTarget::statusAsString)).setter(LambdaTarget.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(LambdaTarget.getter(LambdaTarget::lastUpdatedAt)).setter(LambdaTarget.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build()}).build();
    private static final SdkField<List<LifecycleEvent>> LIFECYCLE_EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lifecycleEvents").getter(LambdaTarget.getter(LambdaTarget::lifecycleEvents)).setter(LambdaTarget.setter(Builder::lifecycleEvents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleEvents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LifecycleEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LambdaFunctionInfo> LAMBDA_FUNCTION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lambdaFunctionInfo").getter(LambdaTarget.getter(LambdaTarget::lambdaFunctionInfo)).setter(LambdaTarget.setter(Builder::lambdaFunctionInfo)).constructor(LambdaFunctionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaFunctionInfo").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD, TARGET_ID_FIELD, TARGET_ARN_FIELD, STATUS_FIELD, LAST_UPDATED_AT_FIELD, LIFECYCLE_EVENTS_FIELD, LAMBDA_FUNCTION_INFO_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deploymentId;
    private final String targetId;
    private final String targetArn;
    private final String status;
    private final Instant lastUpdatedAt;
    private final List<LifecycleEvent> lifecycleEvents;
    private final LambdaFunctionInfo lambdaFunctionInfo;

    private LambdaTarget(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.targetId = builder.targetId;
        this.targetArn = builder.targetArn;
        this.status = builder.status;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.lifecycleEvents = builder.lifecycleEvents;
        this.lambdaFunctionInfo = builder.lambdaFunctionInfo;
    }

    public final String deploymentId() {
        return this.deploymentId;
    }

    public final String targetId() {
        return this.targetId;
    }

    public final String targetArn() {
        return this.targetArn;
    }

    public final TargetStatus status() {
        return TargetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final boolean hasLifecycleEvents() {
        return this.lifecycleEvents != null && !(this.lifecycleEvents instanceof SdkAutoConstructList);
    }

    public final List<LifecycleEvent> lifecycleEvents() {
        return this.lifecycleEvents;
    }

    public final LambdaFunctionInfo lambdaFunctionInfo() {
        return this.lambdaFunctionInfo;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLifecycleEvents() ? this.lifecycleEvents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionInfo());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaTarget)) {
            return false;
        }
        LambdaTarget other = (LambdaTarget)obj;
        return Objects.equals(this.deploymentId(), other.deploymentId()) && Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.targetArn(), other.targetArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && this.hasLifecycleEvents() == other.hasLifecycleEvents() && Objects.equals(this.lifecycleEvents(), other.lifecycleEvents()) && Objects.equals(this.lambdaFunctionInfo(), other.lambdaFunctionInfo());
    }

    public final String toString() {
        return ToString.builder((String)"LambdaTarget").add("DeploymentId", (Object)this.deploymentId()).add("TargetId", (Object)this.targetId()).add("TargetArn", (Object)this.targetArn()).add("Status", (Object)this.statusAsString()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("LifecycleEvents", this.hasLifecycleEvents() ? this.lifecycleEvents() : null).add("LambdaFunctionInfo", (Object)this.lambdaFunctionInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentId": {
                return Optional.ofNullable(clazz.cast(this.deploymentId()));
            }
            case "targetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "targetArn": {
                return Optional.ofNullable(clazz.cast(this.targetArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "lifecycleEvents": {
                return Optional.ofNullable(clazz.cast(this.lifecycleEvents()));
            }
            case "lambdaFunctionInfo": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionInfo()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaTarget, T> g) {
        return obj -> g.apply((LambdaTarget)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentId;
        private String targetId;
        private String targetArn;
        private String status;
        private Instant lastUpdatedAt;
        private List<LifecycleEvent> lifecycleEvents = DefaultSdkAutoConstructList.getInstance();
        private LambdaFunctionInfo lambdaFunctionInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaTarget model) {
            this.deploymentId(model.deploymentId);
            this.targetId(model.targetId);
            this.targetArn(model.targetArn);
            this.status(model.status);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.lifecycleEvents(model.lifecycleEvents);
            this.lambdaFunctionInfo(model.lambdaFunctionInfo);
        }

        public final String getDeploymentId() {
            return this.deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        @Transient
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        @Transient
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getTargetArn() {
            return this.targetArn;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        @Override
        @Transient
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(TargetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        @Transient
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final List<LifecycleEvent.Builder> getLifecycleEvents() {
            List<LifecycleEvent.Builder> result = LifecycleEventListCopier.copyToBuilder(this.lifecycleEvents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLifecycleEvents(Collection<LifecycleEvent.BuilderImpl> lifecycleEvents) {
            this.lifecycleEvents = LifecycleEventListCopier.copyFromBuilder(lifecycleEvents);
        }

        @Override
        @Transient
        public final Builder lifecycleEvents(Collection<LifecycleEvent> lifecycleEvents) {
            this.lifecycleEvents = LifecycleEventListCopier.copy(lifecycleEvents);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lifecycleEvents(LifecycleEvent ... lifecycleEvents) {
            this.lifecycleEvents(Arrays.asList(lifecycleEvents));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder lifecycleEvents(Consumer<LifecycleEvent.Builder> ... lifecycleEvents) {
            this.lifecycleEvents(Stream.of(lifecycleEvents).map(c -> (LifecycleEvent)((LifecycleEvent.Builder)LifecycleEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final LambdaFunctionInfo.Builder getLambdaFunctionInfo() {
            return this.lambdaFunctionInfo != null ? this.lambdaFunctionInfo.toBuilder() : null;
        }

        public final void setLambdaFunctionInfo(LambdaFunctionInfo.BuilderImpl lambdaFunctionInfo) {
            this.lambdaFunctionInfo = lambdaFunctionInfo != null ? lambdaFunctionInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder lambdaFunctionInfo(LambdaFunctionInfo lambdaFunctionInfo) {
            this.lambdaFunctionInfo = lambdaFunctionInfo;
            return this;
        }

        public LambdaTarget build() {
            return new LambdaTarget(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LambdaTarget> {
        public Builder deploymentId(String var1);

        public Builder targetId(String var1);

        public Builder targetArn(String var1);

        public Builder status(String var1);

        public Builder status(TargetStatus var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder lifecycleEvents(Collection<LifecycleEvent> var1);

        public Builder lifecycleEvents(LifecycleEvent ... var1);

        public Builder lifecycleEvents(Consumer<LifecycleEvent.Builder> ... var1);

        public Builder lambdaFunctionInfo(LambdaFunctionInfo var1);

        default public Builder lambdaFunctionInfo(Consumer<LambdaFunctionInfo.Builder> lambdaFunctionInfo) {
            return this.lambdaFunctionInfo((LambdaFunctionInfo)((LambdaFunctionInfo.Builder)LambdaFunctionInfo.builder().applyMutation(lambdaFunctionInfo)).build());
        }
    }
}

