/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the deployment target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentTarget implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentTarget.Builder, DeploymentTarget> {
    private static final SdkField<String> DEPLOYMENT_TARGET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentTargetType").getter(getter(DeploymentTarget::deploymentTargetTypeAsString))
            .setter(setter(Builder::deploymentTargetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentTargetType").build())
            .build();

    private static final SdkField<InstanceTarget> INSTANCE_TARGET_FIELD = SdkField
            .<InstanceTarget> builder(MarshallingType.SDK_POJO).memberName("instanceTarget")
            .getter(getter(DeploymentTarget::instanceTarget)).setter(setter(Builder::instanceTarget))
            .constructor(InstanceTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceTarget").build()).build();

    private static final SdkField<LambdaTarget> LAMBDA_TARGET_FIELD = SdkField.<LambdaTarget> builder(MarshallingType.SDK_POJO)
            .memberName("lambdaTarget").getter(getter(DeploymentTarget::lambdaTarget)).setter(setter(Builder::lambdaTarget))
            .constructor(LambdaTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaTarget").build()).build();

    private static final SdkField<ECSTarget> ECS_TARGET_FIELD = SdkField.<ECSTarget> builder(MarshallingType.SDK_POJO)
            .memberName("ecsTarget").getter(getter(DeploymentTarget::ecsTarget)).setter(setter(Builder::ecsTarget))
            .constructor(ECSTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsTarget").build()).build();

    private static final SdkField<CloudFormationTarget> CLOUD_FORMATION_TARGET_FIELD = SdkField
            .<CloudFormationTarget> builder(MarshallingType.SDK_POJO).memberName("cloudFormationTarget")
            .getter(getter(DeploymentTarget::cloudFormationTarget)).setter(setter(Builder::cloudFormationTarget))
            .constructor(CloudFormationTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudFormationTarget").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_TARGET_TYPE_FIELD,
            INSTANCE_TARGET_FIELD, LAMBDA_TARGET_FIELD, ECS_TARGET_FIELD, CLOUD_FORMATION_TARGET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deploymentTargetType;

    private final InstanceTarget instanceTarget;

    private final LambdaTarget lambdaTarget;

    private final ECSTarget ecsTarget;

    private final CloudFormationTarget cloudFormationTarget;

    private DeploymentTarget(BuilderImpl builder) {
        this.deploymentTargetType = builder.deploymentTargetType;
        this.instanceTarget = builder.instanceTarget;
        this.lambdaTarget = builder.lambdaTarget;
        this.ecsTarget = builder.ecsTarget;
        this.cloudFormationTarget = builder.cloudFormationTarget;
    }

    /**
     * <p>
     * The deployment type that is specific to the deployment's compute platform or deployments initiated by a
     * CloudFormation stack update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deploymentTargetType} will return {@link DeploymentTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deploymentTargetTypeAsString}.
     * </p>
     * 
     * @return The deployment type that is specific to the deployment's compute platform or deployments initiated by a
     *         CloudFormation stack update.
     * @see DeploymentTargetType
     */
    public final DeploymentTargetType deploymentTargetType() {
        return DeploymentTargetType.fromValue(deploymentTargetType);
    }

    /**
     * <p>
     * The deployment type that is specific to the deployment's compute platform or deployments initiated by a
     * CloudFormation stack update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deploymentTargetType} will return {@link DeploymentTargetType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deploymentTargetTypeAsString}.
     * </p>
     * 
     * @return The deployment type that is specific to the deployment's compute platform or deployments initiated by a
     *         CloudFormation stack update.
     * @see DeploymentTargetType
     */
    public final String deploymentTargetTypeAsString() {
        return deploymentTargetType;
    }

    /**
     * <p>
     * Information about the target for a deployment that uses the EC2/On-premises compute platform.
     * </p>
     * 
     * @return Information about the target for a deployment that uses the EC2/On-premises compute platform.
     */
    public final InstanceTarget instanceTarget() {
        return instanceTarget;
    }

    /**
     * <p>
     * Information about the target for a deployment that uses the AWS Lambda compute platform.
     * </p>
     * 
     * @return Information about the target for a deployment that uses the AWS Lambda compute platform.
     */
    public final LambdaTarget lambdaTarget() {
        return lambdaTarget;
    }

    /**
     * <p>
     * Information about the target for a deployment that uses the Amazon ECS compute platform.
     * </p>
     * 
     * @return Information about the target for a deployment that uses the Amazon ECS compute platform.
     */
    public final ECSTarget ecsTarget() {
        return ecsTarget;
    }

    /**
     * Returns the value of the CloudFormationTarget property for this object.
     * 
     * @return The value of the CloudFormationTarget property for this object.
     */
    public final CloudFormationTarget cloudFormationTarget() {
        return cloudFormationTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentTargetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTarget());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaTarget());
        hashCode = 31 * hashCode + Objects.hashCode(ecsTarget());
        hashCode = 31 * hashCode + Objects.hashCode(cloudFormationTarget());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentTarget)) {
            return false;
        }
        DeploymentTarget other = (DeploymentTarget) obj;
        return Objects.equals(deploymentTargetTypeAsString(), other.deploymentTargetTypeAsString())
                && Objects.equals(instanceTarget(), other.instanceTarget())
                && Objects.equals(lambdaTarget(), other.lambdaTarget()) && Objects.equals(ecsTarget(), other.ecsTarget())
                && Objects.equals(cloudFormationTarget(), other.cloudFormationTarget());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentTarget").add("DeploymentTargetType", deploymentTargetTypeAsString())
                .add("InstanceTarget", instanceTarget()).add("LambdaTarget", lambdaTarget()).add("EcsTarget", ecsTarget())
                .add("CloudFormationTarget", cloudFormationTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deploymentTargetType":
            return Optional.ofNullable(clazz.cast(deploymentTargetTypeAsString()));
        case "instanceTarget":
            return Optional.ofNullable(clazz.cast(instanceTarget()));
        case "lambdaTarget":
            return Optional.ofNullable(clazz.cast(lambdaTarget()));
        case "ecsTarget":
            return Optional.ofNullable(clazz.cast(ecsTarget()));
        case "cloudFormationTarget":
            return Optional.ofNullable(clazz.cast(cloudFormationTarget()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentTarget, T> g) {
        return obj -> g.apply((DeploymentTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentTarget> {
        /**
         * <p>
         * The deployment type that is specific to the deployment's compute platform or deployments initiated by a
         * CloudFormation stack update.
         * </p>
         * 
         * @param deploymentTargetType
         *        The deployment type that is specific to the deployment's compute platform or deployments initiated by
         *        a CloudFormation stack update.
         * @see DeploymentTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentTargetType
         */
        Builder deploymentTargetType(String deploymentTargetType);

        /**
         * <p>
         * The deployment type that is specific to the deployment's compute platform or deployments initiated by a
         * CloudFormation stack update.
         * </p>
         * 
         * @param deploymentTargetType
         *        The deployment type that is specific to the deployment's compute platform or deployments initiated by
         *        a CloudFormation stack update.
         * @see DeploymentTargetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentTargetType
         */
        Builder deploymentTargetType(DeploymentTargetType deploymentTargetType);

        /**
         * <p>
         * Information about the target for a deployment that uses the EC2/On-premises compute platform.
         * </p>
         * 
         * @param instanceTarget
         *        Information about the target for a deployment that uses the EC2/On-premises compute platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTarget(InstanceTarget instanceTarget);

        /**
         * <p>
         * Information about the target for a deployment that uses the EC2/On-premises compute platform.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceTarget.Builder} avoiding the need to
         * create one manually via {@link InstanceTarget#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #instanceTarget(InstanceTarget)}.
         * 
         * @param instanceTarget
         *        a consumer that will call methods on {@link InstanceTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceTarget(InstanceTarget)
         */
        default Builder instanceTarget(Consumer<InstanceTarget.Builder> instanceTarget) {
            return instanceTarget(InstanceTarget.builder().applyMutation(instanceTarget).build());
        }

        /**
         * <p>
         * Information about the target for a deployment that uses the AWS Lambda compute platform.
         * </p>
         * 
         * @param lambdaTarget
         *        Information about the target for a deployment that uses the AWS Lambda compute platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaTarget(LambdaTarget lambdaTarget);

        /**
         * <p>
         * Information about the target for a deployment that uses the AWS Lambda compute platform.
         * </p>
         * This is a convenience that creates an instance of the {@link LambdaTarget.Builder} avoiding the need to
         * create one manually via {@link LambdaTarget#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #lambdaTarget(LambdaTarget)}.
         * 
         * @param lambdaTarget
         *        a consumer that will call methods on {@link LambdaTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaTarget(LambdaTarget)
         */
        default Builder lambdaTarget(Consumer<LambdaTarget.Builder> lambdaTarget) {
            return lambdaTarget(LambdaTarget.builder().applyMutation(lambdaTarget).build());
        }

        /**
         * <p>
         * Information about the target for a deployment that uses the Amazon ECS compute platform.
         * </p>
         * 
         * @param ecsTarget
         *        Information about the target for a deployment that uses the Amazon ECS compute platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsTarget(ECSTarget ecsTarget);

        /**
         * <p>
         * Information about the target for a deployment that uses the Amazon ECS compute platform.
         * </p>
         * This is a convenience that creates an instance of the {@link ECSTarget.Builder} avoiding the need to create
         * one manually via {@link ECSTarget#builder()}.
         *
         * When the {@link Consumer} completes, {@link ECSTarget.Builder#build()} is called immediately and its result
         * is passed to {@link #ecsTarget(ECSTarget)}.
         * 
         * @param ecsTarget
         *        a consumer that will call methods on {@link ECSTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecsTarget(ECSTarget)
         */
        default Builder ecsTarget(Consumer<ECSTarget.Builder> ecsTarget) {
            return ecsTarget(ECSTarget.builder().applyMutation(ecsTarget).build());
        }

        /**
         * Sets the value of the CloudFormationTarget property for this object.
         *
         * @param cloudFormationTarget
         *        The new value for the CloudFormationTarget property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFormationTarget(CloudFormationTarget cloudFormationTarget);

        /**
         * Sets the value of the CloudFormationTarget property for this object.
         *
         * This is a convenience that creates an instance of the {@link CloudFormationTarget.Builder} avoiding the need
         * to create one manually via {@link CloudFormationTarget#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudFormationTarget.Builder#build()} is called immediately and
         * its result is passed to {@link #cloudFormationTarget(CloudFormationTarget)}.
         * 
         * @param cloudFormationTarget
         *        a consumer that will call methods on {@link CloudFormationTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFormationTarget(CloudFormationTarget)
         */
        default Builder cloudFormationTarget(Consumer<CloudFormationTarget.Builder> cloudFormationTarget) {
            return cloudFormationTarget(CloudFormationTarget.builder().applyMutation(cloudFormationTarget).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String deploymentTargetType;

        private InstanceTarget instanceTarget;

        private LambdaTarget lambdaTarget;

        private ECSTarget ecsTarget;

        private CloudFormationTarget cloudFormationTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentTarget model) {
            deploymentTargetType(model.deploymentTargetType);
            instanceTarget(model.instanceTarget);
            lambdaTarget(model.lambdaTarget);
            ecsTarget(model.ecsTarget);
            cloudFormationTarget(model.cloudFormationTarget);
        }

        public final String getDeploymentTargetType() {
            return deploymentTargetType;
        }

        @Override
        public final Builder deploymentTargetType(String deploymentTargetType) {
            this.deploymentTargetType = deploymentTargetType;
            return this;
        }

        @Override
        public final Builder deploymentTargetType(DeploymentTargetType deploymentTargetType) {
            this.deploymentTargetType(deploymentTargetType == null ? null : deploymentTargetType.toString());
            return this;
        }

        public final void setDeploymentTargetType(String deploymentTargetType) {
            this.deploymentTargetType = deploymentTargetType;
        }

        public final InstanceTarget.Builder getInstanceTarget() {
            return instanceTarget != null ? instanceTarget.toBuilder() : null;
        }

        @Override
        public final Builder instanceTarget(InstanceTarget instanceTarget) {
            this.instanceTarget = instanceTarget;
            return this;
        }

        public final void setInstanceTarget(InstanceTarget.BuilderImpl instanceTarget) {
            this.instanceTarget = instanceTarget != null ? instanceTarget.build() : null;
        }

        public final LambdaTarget.Builder getLambdaTarget() {
            return lambdaTarget != null ? lambdaTarget.toBuilder() : null;
        }

        @Override
        public final Builder lambdaTarget(LambdaTarget lambdaTarget) {
            this.lambdaTarget = lambdaTarget;
            return this;
        }

        public final void setLambdaTarget(LambdaTarget.BuilderImpl lambdaTarget) {
            this.lambdaTarget = lambdaTarget != null ? lambdaTarget.build() : null;
        }

        public final ECSTarget.Builder getEcsTarget() {
            return ecsTarget != null ? ecsTarget.toBuilder() : null;
        }

        @Override
        public final Builder ecsTarget(ECSTarget ecsTarget) {
            this.ecsTarget = ecsTarget;
            return this;
        }

        public final void setEcsTarget(ECSTarget.BuilderImpl ecsTarget) {
            this.ecsTarget = ecsTarget != null ? ecsTarget.build() : null;
        }

        public final CloudFormationTarget.Builder getCloudFormationTarget() {
            return cloudFormationTarget != null ? cloudFormationTarget.toBuilder() : null;
        }

        @Override
        public final Builder cloudFormationTarget(CloudFormationTarget cloudFormationTarget) {
            this.cloudFormationTarget = cloudFormationTarget;
            return this;
        }

        public final void setCloudFormationTarget(CloudFormationTarget.BuilderImpl cloudFormationTarget) {
            this.cloudFormationTarget = cloudFormationTarget != null ? cloudFormationTarget.build() : null;
        }

        @Override
        public DeploymentTarget build() {
            return new DeploymentTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
