/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployResponse;
import software.amazon.awssdk.services.codedeploy.model.DeploymentGroupsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeploymentGroupsResponse
extends CodeDeployResponse
implements ToCopyableBuilder<Builder, ListDeploymentGroupsResponse> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationName").getter(ListDeploymentGroupsResponse.getter(ListDeploymentGroupsResponse::applicationName)).setter(ListDeploymentGroupsResponse.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()}).build();
    private static final SdkField<List<String>> DEPLOYMENT_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("deploymentGroups").getter(ListDeploymentGroupsResponse.getter(ListDeploymentGroupsResponse::deploymentGroups)).setter(ListDeploymentGroupsResponse.setter(Builder::deploymentGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDeploymentGroupsResponse.getter(ListDeploymentGroupsResponse::nextToken)).setter(ListDeploymentGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, DEPLOYMENT_GROUPS_FIELD, NEXT_TOKEN_FIELD));
    private final String applicationName;
    private final List<String> deploymentGroups;
    private final String nextToken;

    private ListDeploymentGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.deploymentGroups = builder.deploymentGroups;
        this.nextToken = builder.nextToken;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public boolean hasDeploymentGroups() {
        return this.deploymentGroups != null && !(this.deploymentGroups instanceof SdkAutoConstructList);
    }

    public List<String> deploymentGroups() {
        return this.deploymentGroups;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeploymentGroups() ? this.deploymentGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentGroupsResponse)) {
            return false;
        }
        ListDeploymentGroupsResponse other = (ListDeploymentGroupsResponse)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && this.hasDeploymentGroups() == other.hasDeploymentGroups() && Objects.equals(this.deploymentGroups(), other.deploymentGroups()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDeploymentGroupsResponse").add("ApplicationName", (Object)this.applicationName()).add("DeploymentGroups", this.hasDeploymentGroups() ? this.deploymentGroups() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "deploymentGroups": {
                return Optional.ofNullable(clazz.cast(this.deploymentGroups()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeploymentGroupsResponse, T> g) {
        return obj -> g.apply((ListDeploymentGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployResponse.BuilderImpl
    implements Builder {
        private String applicationName;
        private List<String> deploymentGroups = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentGroupsResponse model) {
            super(model);
            this.applicationName(model.applicationName);
            this.deploymentGroups(model.deploymentGroups);
            this.nextToken(model.nextToken);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final Collection<String> getDeploymentGroups() {
            if (this.deploymentGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.deploymentGroups;
        }

        @Override
        public final Builder deploymentGroups(Collection<String> deploymentGroups) {
            this.deploymentGroups = DeploymentGroupsListCopier.copy(deploymentGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentGroups(String ... deploymentGroups) {
            this.deploymentGroups(Arrays.asList(deploymentGroups));
            return this;
        }

        public final void setDeploymentGroups(Collection<String> deploymentGroups) {
            this.deploymentGroups = DeploymentGroupsListCopier.copy(deploymentGroups);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeploymentGroupsResponse build() {
            return new ListDeploymentGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeDeployResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeploymentGroupsResponse> {
        public Builder applicationName(String var1);

        public Builder deploymentGroups(Collection<String> var1);

        public Builder deploymentGroups(String ... var1);

        public Builder nextToken(String var1);
    }
}

