/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.ELBInfo;
import software.amazon.awssdk.services.codedeploy.model.ELBInfoListCopier;
import software.amazon.awssdk.services.codedeploy.model.TargetGroupInfo;
import software.amazon.awssdk.services.codedeploy.model.TargetGroupInfoListCopier;
import software.amazon.awssdk.services.codedeploy.model.TargetGroupPairInfo;
import software.amazon.awssdk.services.codedeploy.model.TargetGroupPairInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoadBalancerInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoadBalancerInfo> {
    private static final SdkField<List<ELBInfo>> ELB_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("elbInfoList").getter(LoadBalancerInfo.getter(LoadBalancerInfo::elbInfoList)).setter(LoadBalancerInfo.setter(Builder::elbInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elbInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ELBInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TargetGroupInfo>> TARGET_GROUP_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetGroupInfoList").getter(LoadBalancerInfo.getter(LoadBalancerInfo::targetGroupInfoList)).setter(LoadBalancerInfo.setter(Builder::targetGroupInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetGroupInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetGroupInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TargetGroupPairInfo>> TARGET_GROUP_PAIR_INFO_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("targetGroupPairInfoList").getter(LoadBalancerInfo.getter(LoadBalancerInfo::targetGroupPairInfoList)).setter(LoadBalancerInfo.setter(Builder::targetGroupPairInfoList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetGroupPairInfoList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetGroupPairInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELB_INFO_LIST_FIELD, TARGET_GROUP_INFO_LIST_FIELD, TARGET_GROUP_PAIR_INFO_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<ELBInfo> elbInfoList;
    private final List<TargetGroupInfo> targetGroupInfoList;
    private final List<TargetGroupPairInfo> targetGroupPairInfoList;

    private LoadBalancerInfo(BuilderImpl builder) {
        this.elbInfoList = builder.elbInfoList;
        this.targetGroupInfoList = builder.targetGroupInfoList;
        this.targetGroupPairInfoList = builder.targetGroupPairInfoList;
    }

    public boolean hasElbInfoList() {
        return this.elbInfoList != null && !(this.elbInfoList instanceof SdkAutoConstructList);
    }

    public List<ELBInfo> elbInfoList() {
        return this.elbInfoList;
    }

    public boolean hasTargetGroupInfoList() {
        return this.targetGroupInfoList != null && !(this.targetGroupInfoList instanceof SdkAutoConstructList);
    }

    public List<TargetGroupInfo> targetGroupInfoList() {
        return this.targetGroupInfoList;
    }

    public boolean hasTargetGroupPairInfoList() {
        return this.targetGroupPairInfoList != null && !(this.targetGroupPairInfoList instanceof SdkAutoConstructList);
    }

    public List<TargetGroupPairInfo> targetGroupPairInfoList() {
        return this.targetGroupPairInfoList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasElbInfoList() ? this.elbInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetGroupInfoList() ? this.targetGroupInfoList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetGroupPairInfoList() ? this.targetGroupPairInfoList() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerInfo)) {
            return false;
        }
        LoadBalancerInfo other = (LoadBalancerInfo)obj;
        return this.hasElbInfoList() == other.hasElbInfoList() && Objects.equals(this.elbInfoList(), other.elbInfoList()) && this.hasTargetGroupInfoList() == other.hasTargetGroupInfoList() && Objects.equals(this.targetGroupInfoList(), other.targetGroupInfoList()) && this.hasTargetGroupPairInfoList() == other.hasTargetGroupPairInfoList() && Objects.equals(this.targetGroupPairInfoList(), other.targetGroupPairInfoList());
    }

    public String toString() {
        return ToString.builder((String)"LoadBalancerInfo").add("ElbInfoList", this.hasElbInfoList() ? this.elbInfoList() : null).add("TargetGroupInfoList", this.hasTargetGroupInfoList() ? this.targetGroupInfoList() : null).add("TargetGroupPairInfoList", this.hasTargetGroupPairInfoList() ? this.targetGroupPairInfoList() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "elbInfoList": {
                return Optional.ofNullable(clazz.cast(this.elbInfoList()));
            }
            case "targetGroupInfoList": {
                return Optional.ofNullable(clazz.cast(this.targetGroupInfoList()));
            }
            case "targetGroupPairInfoList": {
                return Optional.ofNullable(clazz.cast(this.targetGroupPairInfoList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoadBalancerInfo, T> g) {
        return obj -> g.apply((LoadBalancerInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ELBInfo> elbInfoList = DefaultSdkAutoConstructList.getInstance();
        private List<TargetGroupInfo> targetGroupInfoList = DefaultSdkAutoConstructList.getInstance();
        private List<TargetGroupPairInfo> targetGroupPairInfoList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerInfo model) {
            this.elbInfoList(model.elbInfoList);
            this.targetGroupInfoList(model.targetGroupInfoList);
            this.targetGroupPairInfoList(model.targetGroupPairInfoList);
        }

        public final Collection<ELBInfo.Builder> getElbInfoList() {
            if (this.elbInfoList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.elbInfoList != null ? (Collection)this.elbInfoList.stream().map(ELBInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elbInfoList(Collection<ELBInfo> elbInfoList) {
            this.elbInfoList = ELBInfoListCopier.copy(elbInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elbInfoList(ELBInfo ... elbInfoList) {
            this.elbInfoList(Arrays.asList(elbInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elbInfoList(Consumer<ELBInfo.Builder> ... elbInfoList) {
            this.elbInfoList(Stream.of(elbInfoList).map(c -> (ELBInfo)((ELBInfo.Builder)ELBInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setElbInfoList(Collection<ELBInfo.BuilderImpl> elbInfoList) {
            this.elbInfoList = ELBInfoListCopier.copyFromBuilder(elbInfoList);
        }

        public final Collection<TargetGroupInfo.Builder> getTargetGroupInfoList() {
            if (this.targetGroupInfoList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetGroupInfoList != null ? (Collection)this.targetGroupInfoList.stream().map(TargetGroupInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetGroupInfoList(Collection<TargetGroupInfo> targetGroupInfoList) {
            this.targetGroupInfoList = TargetGroupInfoListCopier.copy(targetGroupInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupInfoList(TargetGroupInfo ... targetGroupInfoList) {
            this.targetGroupInfoList(Arrays.asList(targetGroupInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupInfoList(Consumer<TargetGroupInfo.Builder> ... targetGroupInfoList) {
            this.targetGroupInfoList(Stream.of(targetGroupInfoList).map(c -> (TargetGroupInfo)((TargetGroupInfo.Builder)TargetGroupInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetGroupInfoList(Collection<TargetGroupInfo.BuilderImpl> targetGroupInfoList) {
            this.targetGroupInfoList = TargetGroupInfoListCopier.copyFromBuilder(targetGroupInfoList);
        }

        public final Collection<TargetGroupPairInfo.Builder> getTargetGroupPairInfoList() {
            if (this.targetGroupPairInfoList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targetGroupPairInfoList != null ? (Collection)this.targetGroupPairInfoList.stream().map(TargetGroupPairInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targetGroupPairInfoList(Collection<TargetGroupPairInfo> targetGroupPairInfoList) {
            this.targetGroupPairInfoList = TargetGroupPairInfoListCopier.copy(targetGroupPairInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupPairInfoList(TargetGroupPairInfo ... targetGroupPairInfoList) {
            this.targetGroupPairInfoList(Arrays.asList(targetGroupPairInfoList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetGroupPairInfoList(Consumer<TargetGroupPairInfo.Builder> ... targetGroupPairInfoList) {
            this.targetGroupPairInfoList(Stream.of(targetGroupPairInfoList).map(c -> (TargetGroupPairInfo)((TargetGroupPairInfo.Builder)TargetGroupPairInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargetGroupPairInfoList(Collection<TargetGroupPairInfo.BuilderImpl> targetGroupPairInfoList) {
            this.targetGroupPairInfoList = TargetGroupPairInfoListCopier.copyFromBuilder(targetGroupPairInfoList);
        }

        public LoadBalancerInfo build() {
            return new LoadBalancerInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoadBalancerInfo> {
        public Builder elbInfoList(Collection<ELBInfo> var1);

        public Builder elbInfoList(ELBInfo ... var1);

        public Builder elbInfoList(Consumer<ELBInfo.Builder> ... var1);

        public Builder targetGroupInfoList(Collection<TargetGroupInfo> var1);

        public Builder targetGroupInfoList(TargetGroupInfo ... var1);

        public Builder targetGroupInfoList(Consumer<TargetGroupInfo.Builder> ... var1);

        public Builder targetGroupPairInfoList(Collection<TargetGroupPairInfo> var1);

        public Builder targetGroupPairInfoList(TargetGroupPairInfo ... var1);

        public Builder targetGroupPairInfoList(Consumer<TargetGroupPairInfo.Builder> ... var1);
    }
}

