/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum LifecycleErrorCode {
    SUCCESS("Success"),
    SCRIPT_MISSING("ScriptMissing"),
    SCRIPT_NOT_EXECUTABLE("ScriptNotExecutable"),
    SCRIPT_TIMED_OUT("ScriptTimedOut"),
    SCRIPT_FAILED("ScriptFailed"),
    UNKNOWN_ERROR("UnknownError"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private LifecycleErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LifecycleErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(LifecycleErrorCode.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LifecycleErrorCode> knownValues() {
        return Stream.of(LifecycleErrorCode.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

