/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about notification triggers for the deployment group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TriggerConfig implements SdkPojo, Serializable, ToCopyableBuilder<TriggerConfig.Builder, TriggerConfig> {
    private static final SdkField<String> TRIGGER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TriggerConfig::triggerName)).setter(setter(Builder::triggerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerName").build()).build();

    private static final SdkField<String> TRIGGER_TARGET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TriggerConfig::triggerTargetArn)).setter(setter(Builder::triggerTargetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerTargetArn").build()).build();

    private static final SdkField<List<String>> TRIGGER_EVENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(TriggerConfig::triggerEventsAsStrings))
            .setter(setter(Builder::triggerEventsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggerEvents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIGGER_NAME_FIELD,
            TRIGGER_TARGET_ARN_FIELD, TRIGGER_EVENTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String triggerName;

    private final String triggerTargetArn;

    private final List<String> triggerEvents;

    private TriggerConfig(BuilderImpl builder) {
        this.triggerName = builder.triggerName;
        this.triggerTargetArn = builder.triggerTargetArn;
        this.triggerEvents = builder.triggerEvents;
    }

    /**
     * <p>
     * The name of the notification trigger.
     * </p>
     * 
     * @return The name of the notification trigger.
     */
    public String triggerName() {
        return triggerName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic through which notifications about
     * deployment or instance events are sent.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic through which
     *         notifications about deployment or instance events are sent.
     */
    public String triggerTargetArn() {
        return triggerTargetArn;
    }

    /**
     * <p>
     * The event type or types for which notifications are triggered.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTriggerEvents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The event type or types for which notifications are triggered.
     */
    public List<TriggerEventType> triggerEvents() {
        return TriggerEventTypeListCopier.copyStringToEnum(triggerEvents);
    }

    /**
     * Returns true if the TriggerEvents property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTriggerEvents() {
        return triggerEvents != null && !(triggerEvents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The event type or types for which notifications are triggered.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTriggerEvents()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The event type or types for which notifications are triggered.
     */
    public List<String> triggerEventsAsStrings() {
        return triggerEvents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(triggerName());
        hashCode = 31 * hashCode + Objects.hashCode(triggerTargetArn());
        hashCode = 31 * hashCode + Objects.hashCode(triggerEventsAsStrings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriggerConfig)) {
            return false;
        }
        TriggerConfig other = (TriggerConfig) obj;
        return Objects.equals(triggerName(), other.triggerName()) && Objects.equals(triggerTargetArn(), other.triggerTargetArn())
                && Objects.equals(triggerEventsAsStrings(), other.triggerEventsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TriggerConfig").add("TriggerName", triggerName()).add("TriggerTargetArn", triggerTargetArn())
                .add("TriggerEvents", triggerEventsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "triggerName":
            return Optional.ofNullable(clazz.cast(triggerName()));
        case "triggerTargetArn":
            return Optional.ofNullable(clazz.cast(triggerTargetArn()));
        case "triggerEvents":
            return Optional.ofNullable(clazz.cast(triggerEventsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TriggerConfig, T> g) {
        return obj -> g.apply((TriggerConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TriggerConfig> {
        /**
         * <p>
         * The name of the notification trigger.
         * </p>
         * 
         * @param triggerName
         *        The name of the notification trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerName(String triggerName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic through which notifications
         * about deployment or instance events are sent.
         * </p>
         * 
         * @param triggerTargetArn
         *        The Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic through which
         *        notifications about deployment or instance events are sent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerTargetArn(String triggerTargetArn);

        /**
         * <p>
         * The event type or types for which notifications are triggered.
         * </p>
         * 
         * @param triggerEvents
         *        The event type or types for which notifications are triggered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerEventsWithStrings(Collection<String> triggerEvents);

        /**
         * <p>
         * The event type or types for which notifications are triggered.
         * </p>
         * 
         * @param triggerEvents
         *        The event type or types for which notifications are triggered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerEventsWithStrings(String... triggerEvents);

        /**
         * <p>
         * The event type or types for which notifications are triggered.
         * </p>
         * 
         * @param triggerEvents
         *        The event type or types for which notifications are triggered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerEvents(Collection<TriggerEventType> triggerEvents);

        /**
         * <p>
         * The event type or types for which notifications are triggered.
         * </p>
         * 
         * @param triggerEvents
         *        The event type or types for which notifications are triggered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerEvents(TriggerEventType... triggerEvents);
    }

    static final class BuilderImpl implements Builder {
        private String triggerName;

        private String triggerTargetArn;

        private List<String> triggerEvents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TriggerConfig model) {
            triggerName(model.triggerName);
            triggerTargetArn(model.triggerTargetArn);
            triggerEventsWithStrings(model.triggerEvents);
        }

        public final String getTriggerName() {
            return triggerName;
        }

        @Override
        public final Builder triggerName(String triggerName) {
            this.triggerName = triggerName;
            return this;
        }

        public final void setTriggerName(String triggerName) {
            this.triggerName = triggerName;
        }

        public final String getTriggerTargetArn() {
            return triggerTargetArn;
        }

        @Override
        public final Builder triggerTargetArn(String triggerTargetArn) {
            this.triggerTargetArn = triggerTargetArn;
            return this;
        }

        public final void setTriggerTargetArn(String triggerTargetArn) {
            this.triggerTargetArn = triggerTargetArn;
        }

        public final Collection<String> getTriggerEvents() {
            return triggerEvents;
        }

        @Override
        public final Builder triggerEventsWithStrings(Collection<String> triggerEvents) {
            this.triggerEvents = TriggerEventTypeListCopier.copy(triggerEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerEventsWithStrings(String... triggerEvents) {
            triggerEventsWithStrings(Arrays.asList(triggerEvents));
            return this;
        }

        @Override
        public final Builder triggerEvents(Collection<TriggerEventType> triggerEvents) {
            this.triggerEvents = TriggerEventTypeListCopier.copyEnumToString(triggerEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerEvents(TriggerEventType... triggerEvents) {
            triggerEvents(Arrays.asList(triggerEvents));
            return this;
        }

        public final void setTriggerEvents(Collection<String> triggerEvents) {
            this.triggerEvents = TriggerEventTypeListCopier.copy(triggerEvents);
        }

        @Override
        public TriggerConfig build() {
            return new TriggerConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
