/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a Lambda function specified in a deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LambdaFunctionInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<LambdaFunctionInfo.Builder, LambdaFunctionInfo> {
    private static final SdkField<String> FUNCTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LambdaFunctionInfo::functionName)).setter(setter(Builder::functionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionName").build()).build();

    private static final SdkField<String> FUNCTION_ALIAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LambdaFunctionInfo::functionAlias)).setter(setter(Builder::functionAlias))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionAlias").build()).build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LambdaFunctionInfo::currentVersion)).setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()).build();

    private static final SdkField<String> TARGET_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LambdaFunctionInfo::targetVersion)).setter(setter(Builder::targetVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetVersion").build()).build();

    private static final SdkField<Double> TARGET_VERSION_WEIGHT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(LambdaFunctionInfo::targetVersionWeight)).setter(setter(Builder::targetVersionWeight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetVersionWeight").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FUNCTION_NAME_FIELD,
            FUNCTION_ALIAS_FIELD, CURRENT_VERSION_FIELD, TARGET_VERSION_FIELD, TARGET_VERSION_WEIGHT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String functionName;

    private final String functionAlias;

    private final String currentVersion;

    private final String targetVersion;

    private final Double targetVersionWeight;

    private LambdaFunctionInfo(BuilderImpl builder) {
        this.functionName = builder.functionName;
        this.functionAlias = builder.functionAlias;
        this.currentVersion = builder.currentVersion;
        this.targetVersion = builder.targetVersion;
        this.targetVersionWeight = builder.targetVersionWeight;
    }

    /**
     * <p>
     * The name of a Lambda function.
     * </p>
     * 
     * @return The name of a Lambda function.
     */
    public String functionName() {
        return functionName;
    }

    /**
     * <p>
     * The alias of a Lambda function. For more information, see <a
     * href="https://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">AWS Lambda Function Aliases</a> in the
     * <i>AWS Lambda Developer Guide</i>.
     * </p>
     * 
     * @return The alias of a Lambda function. For more information, see <a
     *         href="https://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">AWS Lambda Function Aliases</a> in
     *         the <i>AWS Lambda Developer Guide</i>.
     */
    public String functionAlias() {
        return functionAlias;
    }

    /**
     * <p>
     * The version of a Lambda function that production traffic points to.
     * </p>
     * 
     * @return The version of a Lambda function that production traffic points to.
     */
    public String currentVersion() {
        return currentVersion;
    }

    /**
     * <p>
     * The version of a Lambda function that production traffic points to after the Lambda function is deployed.
     * </p>
     * 
     * @return The version of a Lambda function that production traffic points to after the Lambda function is deployed.
     */
    public String targetVersion() {
        return targetVersion;
    }

    /**
     * <p>
     * The percentage of production traffic that the target version of a Lambda function receives.
     * </p>
     * 
     * @return The percentage of production traffic that the target version of a Lambda function receives.
     */
    public Double targetVersionWeight() {
        return targetVersionWeight;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(functionName());
        hashCode = 31 * hashCode + Objects.hashCode(functionAlias());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(targetVersion());
        hashCode = 31 * hashCode + Objects.hashCode(targetVersionWeight());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LambdaFunctionInfo)) {
            return false;
        }
        LambdaFunctionInfo other = (LambdaFunctionInfo) obj;
        return Objects.equals(functionName(), other.functionName()) && Objects.equals(functionAlias(), other.functionAlias())
                && Objects.equals(currentVersion(), other.currentVersion())
                && Objects.equals(targetVersion(), other.targetVersion())
                && Objects.equals(targetVersionWeight(), other.targetVersionWeight());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LambdaFunctionInfo").add("FunctionName", functionName()).add("FunctionAlias", functionAlias())
                .add("CurrentVersion", currentVersion()).add("TargetVersion", targetVersion())
                .add("TargetVersionWeight", targetVersionWeight()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "functionName":
            return Optional.ofNullable(clazz.cast(functionName()));
        case "functionAlias":
            return Optional.ofNullable(clazz.cast(functionAlias()));
        case "currentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "targetVersion":
            return Optional.ofNullable(clazz.cast(targetVersion()));
        case "targetVersionWeight":
            return Optional.ofNullable(clazz.cast(targetVersionWeight()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LambdaFunctionInfo, T> g) {
        return obj -> g.apply((LambdaFunctionInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LambdaFunctionInfo> {
        /**
         * <p>
         * The name of a Lambda function.
         * </p>
         * 
         * @param functionName
         *        The name of a Lambda function.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionName(String functionName);

        /**
         * <p>
         * The alias of a Lambda function. For more information, see <a
         * href="https://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">AWS Lambda Function Aliases</a> in the
         * <i>AWS Lambda Developer Guide</i>.
         * </p>
         * 
         * @param functionAlias
         *        The alias of a Lambda function. For more information, see <a
         *        href="https://docs.aws.amazon.com/lambda/latest/dg/aliases-intro.html">AWS Lambda Function Aliases</a>
         *        in the <i>AWS Lambda Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionAlias(String functionAlias);

        /**
         * <p>
         * The version of a Lambda function that production traffic points to.
         * </p>
         * 
         * @param currentVersion
         *        The version of a Lambda function that production traffic points to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         * <p>
         * The version of a Lambda function that production traffic points to after the Lambda function is deployed.
         * </p>
         * 
         * @param targetVersion
         *        The version of a Lambda function that production traffic points to after the Lambda function is
         *        deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVersion(String targetVersion);

        /**
         * <p>
         * The percentage of production traffic that the target version of a Lambda function receives.
         * </p>
         * 
         * @param targetVersionWeight
         *        The percentage of production traffic that the target version of a Lambda function receives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVersionWeight(Double targetVersionWeight);
    }

    static final class BuilderImpl implements Builder {
        private String functionName;

        private String functionAlias;

        private String currentVersion;

        private String targetVersion;

        private Double targetVersionWeight;

        private BuilderImpl() {
        }

        private BuilderImpl(LambdaFunctionInfo model) {
            functionName(model.functionName);
            functionAlias(model.functionAlias);
            currentVersion(model.currentVersion);
            targetVersion(model.targetVersion);
            targetVersionWeight(model.targetVersionWeight);
        }

        public final String getFunctionName() {
            return functionName;
        }

        @Override
        public final Builder functionName(String functionName) {
            this.functionName = functionName;
            return this;
        }

        public final void setFunctionName(String functionName) {
            this.functionName = functionName;
        }

        public final String getFunctionAlias() {
            return functionAlias;
        }

        @Override
        public final Builder functionAlias(String functionAlias) {
            this.functionAlias = functionAlias;
            return this;
        }

        public final void setFunctionAlias(String functionAlias) {
            this.functionAlias = functionAlias;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        public final String getTargetVersion() {
            return targetVersion;
        }

        @Override
        public final Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public final void setTargetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
        }

        public final Double getTargetVersionWeight() {
            return targetVersionWeight;
        }

        @Override
        public final Builder targetVersionWeight(Double targetVersionWeight) {
            this.targetVersionWeight = targetVersionWeight;
            return this;
        }

        public final void setTargetVersionWeight(Double targetVersionWeight) {
            this.targetVersionWeight = targetVersionWeight;
        }

        @Override
        public LambdaFunctionInfo build() {
            return new LambdaFunctionInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
