/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployResponse;
import software.amazon.awssdk.services.codedeploy.model.TargetIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDeploymentTargetsResponse
extends CodeDeployResponse
implements ToCopyableBuilder<Builder, ListDeploymentTargetsResponse> {
    private static final SdkField<List<String>> TARGET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListDeploymentTargetsResponse.getter(ListDeploymentTargetsResponse::targetIds)).setter(ListDeploymentTargetsResponse.setter(Builder::targetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListDeploymentTargetsResponse.getter(ListDeploymentTargetsResponse::nextToken)).setter(ListDeploymentTargetsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_IDS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> targetIds;
    private final String nextToken;

    private ListDeploymentTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.targetIds = builder.targetIds;
        this.nextToken = builder.nextToken;
    }

    public boolean hasTargetIds() {
        return this.targetIds != null && !(this.targetIds instanceof SdkAutoConstructList);
    }

    public List<String> targetIds() {
        return this.targetIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentTargetsResponse)) {
            return false;
        }
        ListDeploymentTargetsResponse other = (ListDeploymentTargetsResponse)((Object)obj);
        return Objects.equals(this.targetIds(), other.targetIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDeploymentTargetsResponse").add("TargetIds", this.targetIds()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetIds": {
                return Optional.ofNullable(clazz.cast(this.targetIds()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDeploymentTargetsResponse, T> g) {
        return obj -> g.apply((ListDeploymentTargetsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployResponse.BuilderImpl
    implements Builder {
        private List<String> targetIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentTargetsResponse model) {
            super(model);
            this.targetIds(model.targetIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getTargetIds() {
            return this.targetIds;
        }

        @Override
        public final Builder targetIds(Collection<String> targetIds) {
            this.targetIds = TargetIdListCopier.copy(targetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetIds(String ... targetIds) {
            this.targetIds(Arrays.asList(targetIds));
            return this;
        }

        public final void setTargetIds(Collection<String> targetIds) {
            this.targetIds = TargetIdListCopier.copy(targetIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeploymentTargetsResponse build() {
            return new ListDeploymentTargetsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeDeployResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDeploymentTargetsResponse> {
        public Builder targetIds(Collection<String> var1);

        public Builder targetIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

