/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the deployment status of the instances in the deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentOverview implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentOverview.Builder, DeploymentOverview> {
    private static final SdkField<Long> PENDING_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DeploymentOverview::pending)).setter(setter(Builder::pending))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Pending").build()).build();

    private static final SdkField<Long> IN_PROGRESS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DeploymentOverview::inProgress)).setter(setter(Builder::inProgress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InProgress").build()).build();

    private static final SdkField<Long> SUCCEEDED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DeploymentOverview::succeeded)).setter(setter(Builder::succeeded))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Succeeded").build()).build();

    private static final SdkField<Long> FAILED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DeploymentOverview::failed)).setter(setter(Builder::failed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build()).build();

    private static final SdkField<Long> SKIPPED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DeploymentOverview::skipped)).setter(setter(Builder::skipped))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Skipped").build()).build();

    private static final SdkField<Long> READY_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DeploymentOverview::ready)).setter(setter(Builder::ready))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ready").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PENDING_FIELD,
            IN_PROGRESS_FIELD, SUCCEEDED_FIELD, FAILED_FIELD, SKIPPED_FIELD, READY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long pending;

    private final Long inProgress;

    private final Long succeeded;

    private final Long failed;

    private final Long skipped;

    private final Long ready;

    private DeploymentOverview(BuilderImpl builder) {
        this.pending = builder.pending;
        this.inProgress = builder.inProgress;
        this.succeeded = builder.succeeded;
        this.failed = builder.failed;
        this.skipped = builder.skipped;
        this.ready = builder.ready;
    }

    /**
     * <p>
     * The number of instances in the deployment in a pending state.
     * </p>
     * 
     * @return The number of instances in the deployment in a pending state.
     */
    public Long pending() {
        return pending;
    }

    /**
     * <p>
     * The number of instances in which the deployment is in progress.
     * </p>
     * 
     * @return The number of instances in which the deployment is in progress.
     */
    public Long inProgress() {
        return inProgress;
    }

    /**
     * <p>
     * The number of instances in the deployment to which revisions have been successfully deployed.
     * </p>
     * 
     * @return The number of instances in the deployment to which revisions have been successfully deployed.
     */
    public Long succeeded() {
        return succeeded;
    }

    /**
     * <p>
     * The number of instances in the deployment in a failed state.
     * </p>
     * 
     * @return The number of instances in the deployment in a failed state.
     */
    public Long failed() {
        return failed;
    }

    /**
     * <p>
     * The number of instances in the deployment in a skipped state.
     * </p>
     * 
     * @return The number of instances in the deployment in a skipped state.
     */
    public Long skipped() {
        return skipped;
    }

    /**
     * <p>
     * The number of instances in a replacement environment ready to receive traffic in a blue/green deployment.
     * </p>
     * 
     * @return The number of instances in a replacement environment ready to receive traffic in a blue/green deployment.
     */
    public Long ready() {
        return ready;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(pending());
        hashCode = 31 * hashCode + Objects.hashCode(inProgress());
        hashCode = 31 * hashCode + Objects.hashCode(succeeded());
        hashCode = 31 * hashCode + Objects.hashCode(failed());
        hashCode = 31 * hashCode + Objects.hashCode(skipped());
        hashCode = 31 * hashCode + Objects.hashCode(ready());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentOverview)) {
            return false;
        }
        DeploymentOverview other = (DeploymentOverview) obj;
        return Objects.equals(pending(), other.pending()) && Objects.equals(inProgress(), other.inProgress())
                && Objects.equals(succeeded(), other.succeeded()) && Objects.equals(failed(), other.failed())
                && Objects.equals(skipped(), other.skipped()) && Objects.equals(ready(), other.ready());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeploymentOverview").add("Pending", pending()).add("InProgress", inProgress())
                .add("Succeeded", succeeded()).add("Failed", failed()).add("Skipped", skipped()).add("Ready", ready()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Pending":
            return Optional.ofNullable(clazz.cast(pending()));
        case "InProgress":
            return Optional.ofNullable(clazz.cast(inProgress()));
        case "Succeeded":
            return Optional.ofNullable(clazz.cast(succeeded()));
        case "Failed":
            return Optional.ofNullable(clazz.cast(failed()));
        case "Skipped":
            return Optional.ofNullable(clazz.cast(skipped()));
        case "Ready":
            return Optional.ofNullable(clazz.cast(ready()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentOverview, T> g) {
        return obj -> g.apply((DeploymentOverview) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentOverview> {
        /**
         * <p>
         * The number of instances in the deployment in a pending state.
         * </p>
         * 
         * @param pending
         *        The number of instances in the deployment in a pending state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pending(Long pending);

        /**
         * <p>
         * The number of instances in which the deployment is in progress.
         * </p>
         * 
         * @param inProgress
         *        The number of instances in which the deployment is in progress.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inProgress(Long inProgress);

        /**
         * <p>
         * The number of instances in the deployment to which revisions have been successfully deployed.
         * </p>
         * 
         * @param succeeded
         *        The number of instances in the deployment to which revisions have been successfully deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder succeeded(Long succeeded);

        /**
         * <p>
         * The number of instances in the deployment in a failed state.
         * </p>
         * 
         * @param failed
         *        The number of instances in the deployment in a failed state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failed(Long failed);

        /**
         * <p>
         * The number of instances in the deployment in a skipped state.
         * </p>
         * 
         * @param skipped
         *        The number of instances in the deployment in a skipped state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipped(Long skipped);

        /**
         * <p>
         * The number of instances in a replacement environment ready to receive traffic in a blue/green deployment.
         * </p>
         * 
         * @param ready
         *        The number of instances in a replacement environment ready to receive traffic in a blue/green
         *        deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ready(Long ready);
    }

    static final class BuilderImpl implements Builder {
        private Long pending;

        private Long inProgress;

        private Long succeeded;

        private Long failed;

        private Long skipped;

        private Long ready;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentOverview model) {
            pending(model.pending);
            inProgress(model.inProgress);
            succeeded(model.succeeded);
            failed(model.failed);
            skipped(model.skipped);
            ready(model.ready);
        }

        public final Long getPending() {
            return pending;
        }

        @Override
        public final Builder pending(Long pending) {
            this.pending = pending;
            return this;
        }

        public final void setPending(Long pending) {
            this.pending = pending;
        }

        public final Long getInProgress() {
            return inProgress;
        }

        @Override
        public final Builder inProgress(Long inProgress) {
            this.inProgress = inProgress;
            return this;
        }

        public final void setInProgress(Long inProgress) {
            this.inProgress = inProgress;
        }

        public final Long getSucceeded() {
            return succeeded;
        }

        @Override
        public final Builder succeeded(Long succeeded) {
            this.succeeded = succeeded;
            return this;
        }

        public final void setSucceeded(Long succeeded) {
            this.succeeded = succeeded;
        }

        public final Long getFailed() {
            return failed;
        }

        @Override
        public final Builder failed(Long failed) {
            this.failed = failed;
            return this;
        }

        public final void setFailed(Long failed) {
            this.failed = failed;
        }

        public final Long getSkipped() {
            return skipped;
        }

        @Override
        public final Builder skipped(Long skipped) {
            this.skipped = skipped;
            return this;
        }

        public final void setSkipped(Long skipped) {
            this.skipped = skipped;
        }

        public final Long getReady() {
            return ready;
        }

        @Override
        public final Builder ready(Long ready) {
            this.ready = ready;
            return this;
        }

        public final void setReady(Long ready) {
            this.ready = ready;
        }

        @Override
        public DeploymentOverview build() {
            return new DeploymentOverview(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
