/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.RollbackInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RollbackInfoMarshaller {
    private static final MarshallingInfo<String> ROLLBACKDEPLOYMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rollbackDeploymentId").isBinary(false).build();
    private static final MarshallingInfo<String> ROLLBACKTRIGGERINGDEPLOYMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rollbackTriggeringDeploymentId").isBinary(false).build();
    private static final MarshallingInfo<String> ROLLBACKMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rollbackMessage").isBinary(false).build();
    private static final RollbackInfoMarshaller INSTANCE = new RollbackInfoMarshaller();

    private RollbackInfoMarshaller() {
    }

    public static RollbackInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RollbackInfo rollbackInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)rollbackInfo, (String)"rollbackInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)rollbackInfo.rollbackDeploymentId(), ROLLBACKDEPLOYMENTID_BINDING);
            protocolMarshaller.marshall((Object)rollbackInfo.rollbackTriggeringDeploymentId(), ROLLBACKTRIGGERINGDEPLOYMENTID_BINDING);
            protocolMarshaller.marshall((Object)rollbackInfo.rollbackMessage(), ROLLBACKMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

