/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.InstanceInfo;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceInfoMarshaller {
    private static final MarshallingInfo<String> INSTANCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceName").isBinary(false).build();
    private static final MarshallingInfo<String> IAMSESSIONARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iamSessionArn").isBinary(false).build();
    private static final MarshallingInfo<String> IAMUSERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("iamUserArn").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceArn").isBinary(false).build();
    private static final MarshallingInfo<Instant> REGISTERTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("registerTime").isBinary(false).build();
    private static final MarshallingInfo<Instant> DEREGISTERTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deregisterTime").isBinary(false).build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tags").isBinary(false).build();
    private static final InstanceInfoMarshaller INSTANCE = new InstanceInfoMarshaller();

    private InstanceInfoMarshaller() {
    }

    public static InstanceInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceInfo instanceInfo, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instanceInfo, (String)"instanceInfo");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instanceInfo.instanceName(), INSTANCENAME_BINDING);
            protocolMarshaller.marshall((Object)instanceInfo.iamSessionArn(), IAMSESSIONARN_BINDING);
            protocolMarshaller.marshall((Object)instanceInfo.iamUserArn(), IAMUSERARN_BINDING);
            protocolMarshaller.marshall((Object)instanceInfo.instanceArn(), INSTANCEARN_BINDING);
            protocolMarshaller.marshall((Object)instanceInfo.registerTime(), REGISTERTIME_BINDING);
            protocolMarshaller.marshall((Object)instanceInfo.deregisterTime(), DEREGISTERTIME_BINDING);
            protocolMarshaller.marshall(instanceInfo.tags(), TAGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

