/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.EC2TagSet;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EC2TagSetMarshaller {
    private static final MarshallingInfo<List> EC2TAGSETLIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ec2TagSetList").isBinary(false).build();
    private static final EC2TagSetMarshaller INSTANCE = new EC2TagSetMarshaller();

    private EC2TagSetMarshaller() {
    }

    public static EC2TagSetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EC2TagSet ec2TagSet, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ec2TagSet, (String)"ec2TagSet");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(ec2TagSet.ec2TagSetList(), EC2TAGSETLIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

