/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.codedeploy.CodeDeployClient;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListDeploymentConfigsResponse;

public class ListDeploymentConfigsIterable
implements SdkIterable<ListDeploymentConfigsResponse> {
    private final CodeDeployClient client;
    private final ListDeploymentConfigsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDeploymentConfigsIterable(CodeDeployClient client, ListDeploymentConfigsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDeploymentConfigsResponseFetcher();
    }

    public Iterator<ListDeploymentConfigsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<String> deploymentConfigsList() {
        Function<ListDeploymentConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.deploymentConfigsList() != null) {
                return response.deploymentConfigsList().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListDeploymentConfigsIterable resume(ListDeploymentConfigsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListDeploymentConfigsIterable(this.client, (ListDeploymentConfigsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListDeploymentConfigsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListDeploymentConfigsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListDeploymentConfigsResponseFetcher
    implements SyncPageFetcher<ListDeploymentConfigsResponse> {
        private ListDeploymentConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentConfigsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListDeploymentConfigsResponse nextPage(ListDeploymentConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentConfigsIterable.this.client.listDeploymentConfigs(ListDeploymentConfigsIterable.this.firstRequest);
            }
            return ListDeploymentConfigsIterable.this.client.listDeploymentConfigs((ListDeploymentConfigsRequest)((Object)ListDeploymentConfigsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

