/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.codedeploy.CodeDeployClient;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsRequest;
import software.amazon.awssdk.services.codedeploy.model.ListApplicationRevisionsResponse;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;

public class ListApplicationRevisionsIterable
implements SdkIterable<ListApplicationRevisionsResponse> {
    private final CodeDeployClient client;
    private final ListApplicationRevisionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationRevisionsIterable(CodeDeployClient client, ListApplicationRevisionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListApplicationRevisionsResponseFetcher();
    }

    public Iterator<ListApplicationRevisionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<RevisionLocation> revisions() {
        Function<ListApplicationRevisionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.revisions() != null) {
                return response.revisions().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListApplicationRevisionsIterable resume(ListApplicationRevisionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListApplicationRevisionsIterable(this.client, (ListApplicationRevisionsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListApplicationRevisionsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListApplicationRevisionsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListApplicationRevisionsResponseFetcher
    implements SyncPageFetcher<ListApplicationRevisionsResponse> {
        private ListApplicationRevisionsResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationRevisionsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListApplicationRevisionsResponse nextPage(ListApplicationRevisionsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationRevisionsIterable.this.client.listApplicationRevisions(ListApplicationRevisionsIterable.this.firstRequest);
            }
            return ListApplicationRevisionsIterable.this.client.listApplicationRevisions((ListApplicationRevisionsRequest)((Object)ListApplicationRevisionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

