/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployResponse;
import software.amazon.awssdk.services.codedeploy.model.DeploymentConfigsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListDeploymentConfigsResponse
extends CodeDeployResponse
implements ToCopyableBuilder<Builder, ListDeploymentConfigsResponse> {
    private final List<String> deploymentConfigsList;
    private final String nextToken;

    private ListDeploymentConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.deploymentConfigsList = builder.deploymentConfigsList;
        this.nextToken = builder.nextToken;
    }

    public List<String> deploymentConfigsList() {
        return this.deploymentConfigsList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfigsList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDeploymentConfigsResponse)) {
            return false;
        }
        ListDeploymentConfigsResponse other = (ListDeploymentConfigsResponse)((Object)obj);
        return Objects.equals(this.deploymentConfigsList(), other.deploymentConfigsList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListDeploymentConfigsResponse").add("DeploymentConfigsList", this.deploymentConfigsList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentConfigsList": {
                return Optional.of(clazz.cast(this.deploymentConfigsList()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeDeployResponse.BuilderImpl
    implements Builder {
        private List<String> deploymentConfigsList;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDeploymentConfigsResponse model) {
            this.deploymentConfigsList(model.deploymentConfigsList);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getDeploymentConfigsList() {
            return this.deploymentConfigsList;
        }

        @Override
        public final Builder deploymentConfigsList(Collection<String> deploymentConfigsList) {
            this.deploymentConfigsList = DeploymentConfigsListCopier.copy(deploymentConfigsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentConfigsList(String ... deploymentConfigsList) {
            this.deploymentConfigsList(Arrays.asList(deploymentConfigsList));
            return this;
        }

        public final void setDeploymentConfigsList(Collection<String> deploymentConfigsList) {
            this.deploymentConfigsList = DeploymentConfigsListCopier.copy(deploymentConfigsList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListDeploymentConfigsResponse build() {
            return new ListDeploymentConfigsResponse(this);
        }
    }

    public static interface Builder
    extends CodeDeployResponse.Builder,
    CopyableBuilder<Builder, ListDeploymentConfigsResponse> {
        public Builder deploymentConfigsList(Collection<String> var1);

        public Builder deploymentConfigsList(String ... var1);

        public Builder nextToken(String var1);
    }
}

