/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.codedeploy.model.ApplicationRevisionSortBy;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.ListStateFilterAction;
import software.amazon.awssdk.services.codedeploy.model.SortOrder;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListApplicationRevisionsRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, ListApplicationRevisionsRequest> {
    private final String applicationName;
    private final String sortBy;
    private final String sortOrder;
    private final String s3Bucket;
    private final String s3KeyPrefix;
    private final String deployed;
    private final String nextToken;

    private ListApplicationRevisionsRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.s3Bucket = builder.s3Bucket;
        this.s3KeyPrefix = builder.s3KeyPrefix;
        this.deployed = builder.deployed;
        this.nextToken = builder.nextToken;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public ApplicationRevisionSortBy sortBy() {
        return ApplicationRevisionSortBy.fromValue(this.sortBy);
    }

    public String sortByString() {
        return this.sortBy;
    }

    public SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public String sortOrderString() {
        return this.sortOrder;
    }

    public String s3Bucket() {
        return this.s3Bucket;
    }

    public String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public ListStateFilterAction deployed() {
        return ListStateFilterAction.fromValue(this.deployed);
    }

    public String deployedString() {
        return this.deployed;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3KeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.deployedString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApplicationRevisionsRequest)) {
            return false;
        }
        ListApplicationRevisionsRequest other = (ListApplicationRevisionsRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.sortByString(), other.sortByString()) && Objects.equals(this.sortOrderString(), other.sortOrderString()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.s3KeyPrefix(), other.s3KeyPrefix()) && Objects.equals(this.deployedString(), other.deployedString()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListApplicationRevisionsRequest").add("ApplicationName", (Object)this.applicationName()).add("SortBy", (Object)this.sortByString()).add("SortOrder", (Object)this.sortOrderString()).add("S3Bucket", (Object)this.s3Bucket()).add("S3KeyPrefix", (Object)this.s3KeyPrefix()).add("Deployed", (Object)this.deployedString()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "sortBy": {
                return Optional.of(clazz.cast(this.sortByString()));
            }
            case "sortOrder": {
                return Optional.of(clazz.cast(this.sortOrderString()));
            }
            case "s3Bucket": {
                return Optional.of(clazz.cast(this.s3Bucket()));
            }
            case "s3KeyPrefix": {
                return Optional.of(clazz.cast(this.s3KeyPrefix()));
            }
            case "deployed": {
                return Optional.of(clazz.cast(this.deployedString()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String sortBy;
        private String sortOrder;
        private String s3Bucket;
        private String s3KeyPrefix;
        private String deployed;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApplicationRevisionsRequest model) {
            this.applicationName(model.applicationName);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.s3Bucket(model.s3Bucket);
            this.s3KeyPrefix(model.s3KeyPrefix);
            this.deployed(model.deployed);
            this.nextToken(model.nextToken);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ApplicationRevisionSortBy sortBy) {
            this.sortBy(sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final Builder s3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        public final void setS3Bucket(String s3Bucket) {
            this.s3Bucket = s3Bucket;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        public final String getDeployed() {
            return this.deployed;
        }

        @Override
        public final Builder deployed(String deployed) {
            this.deployed = deployed;
            return this;
        }

        @Override
        public final Builder deployed(ListStateFilterAction deployed) {
            this.deployed(deployed.toString());
            return this;
        }

        public final void setDeployed(String deployed) {
            this.deployed = deployed;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListApplicationRevisionsRequest build() {
            return new ListApplicationRevisionsRequest(this);
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    CopyableBuilder<Builder, ListApplicationRevisionsRequest> {
        public Builder applicationName(String var1);

        public Builder sortBy(String var1);

        public Builder sortBy(ApplicationRevisionSortBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder s3Bucket(String var1);

        public Builder s3KeyPrefix(String var1);

        public Builder deployed(String var1);

        public Builder deployed(ListStateFilterAction var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

