/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHosts;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDeploymentConfigRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, CreateDeploymentConfigRequest> {
    private final String deploymentConfigName;
    private final MinimumHealthyHosts minimumHealthyHosts;

    private CreateDeploymentConfigRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentConfigName = builder.deploymentConfigName;
        this.minimumHealthyHosts = builder.minimumHealthyHosts;
    }

    public String deploymentConfigName() {
        return this.deploymentConfigName;
    }

    public MinimumHealthyHosts minimumHealthyHosts() {
        return this.minimumHealthyHosts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumHealthyHosts());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentConfigRequest)) {
            return false;
        }
        CreateDeploymentConfigRequest other = (CreateDeploymentConfigRequest)((Object)obj);
        return Objects.equals(this.deploymentConfigName(), other.deploymentConfigName()) && Objects.equals(this.minimumHealthyHosts(), other.minimumHealthyHosts());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.deploymentConfigName() != null) {
            sb.append("DeploymentConfigName: ").append(this.deploymentConfigName()).append(",");
        }
        if (this.minimumHealthyHosts() != null) {
            sb.append("MinimumHealthyHosts: ").append(this.minimumHealthyHosts()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentConfigName": {
                return Optional.of(clazz.cast(this.deploymentConfigName()));
            }
            case "minimumHealthyHosts": {
                return Optional.of(clazz.cast(this.minimumHealthyHosts()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String deploymentConfigName;
        private MinimumHealthyHosts minimumHealthyHosts;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentConfigRequest model) {
            this.deploymentConfigName(model.deploymentConfigName);
            this.minimumHealthyHosts(model.minimumHealthyHosts);
        }

        public final String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final MinimumHealthyHosts.Builder getMinimumHealthyHosts() {
            return this.minimumHealthyHosts != null ? this.minimumHealthyHosts.toBuilder() : null;
        }

        @Override
        public final Builder minimumHealthyHosts(MinimumHealthyHosts minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts;
            return this;
        }

        public final void setMinimumHealthyHosts(MinimumHealthyHosts.BuilderImpl minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts != null ? minimumHealthyHosts.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentConfigRequest build() {
            return new CreateDeploymentConfigRequest(this);
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    CopyableBuilder<Builder, CreateDeploymentConfigRequest> {
        public Builder deploymentConfigName(String var1);

        public Builder minimumHealthyHosts(MinimumHealthyHosts var1);

        default public Builder minimumHealthyHosts(Consumer<MinimumHealthyHosts.Builder> minimumHealthyHosts) {
            return this.minimumHealthyHosts((MinimumHealthyHosts)((MinimumHealthyHosts.Builder)MinimumHealthyHosts.builder().apply(minimumHealthyHosts)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

