/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.codedeploy.model.AlarmConfiguration;
import software.amazon.awssdk.services.codedeploy.model.AutoRollbackConfiguration;
import software.amazon.awssdk.services.codedeploy.model.AutoScalingGroupNameListCopier;
import software.amazon.awssdk.services.codedeploy.model.BlueGreenDeploymentConfiguration;
import software.amazon.awssdk.services.codedeploy.model.DeploymentStyle;
import software.amazon.awssdk.services.codedeploy.model.EC2TagFilter;
import software.amazon.awssdk.services.codedeploy.model.EC2TagFilterListCopier;
import software.amazon.awssdk.services.codedeploy.model.EC2TagSet;
import software.amazon.awssdk.services.codedeploy.model.LoadBalancerInfo;
import software.amazon.awssdk.services.codedeploy.model.OnPremisesTagSet;
import software.amazon.awssdk.services.codedeploy.model.TagFilter;
import software.amazon.awssdk.services.codedeploy.model.TagFilterListCopier;
import software.amazon.awssdk.services.codedeploy.model.TriggerConfig;
import software.amazon.awssdk.services.codedeploy.model.TriggerConfigListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateDeploymentGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateDeploymentGroupRequest> {
    private final String applicationName;
    private final String deploymentGroupName;
    private final String deploymentConfigName;
    private final List<EC2TagFilter> ec2TagFilters;
    private final List<TagFilter> onPremisesInstanceTagFilters;
    private final List<String> autoScalingGroups;
    private final String serviceRoleArn;
    private final List<TriggerConfig> triggerConfigurations;
    private final AlarmConfiguration alarmConfiguration;
    private final AutoRollbackConfiguration autoRollbackConfiguration;
    private final DeploymentStyle deploymentStyle;
    private final BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;
    private final LoadBalancerInfo loadBalancerInfo;
    private final EC2TagSet ec2TagSet;
    private final OnPremisesTagSet onPremisesTagSet;

    private CreateDeploymentGroupRequest(BuilderImpl builder) {
        this.applicationName = builder.applicationName;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.ec2TagFilters = builder.ec2TagFilters;
        this.onPremisesInstanceTagFilters = builder.onPremisesInstanceTagFilters;
        this.autoScalingGroups = builder.autoScalingGroups;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.triggerConfigurations = builder.triggerConfigurations;
        this.alarmConfiguration = builder.alarmConfiguration;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.deploymentStyle = builder.deploymentStyle;
        this.blueGreenDeploymentConfiguration = builder.blueGreenDeploymentConfiguration;
        this.loadBalancerInfo = builder.loadBalancerInfo;
        this.ec2TagSet = builder.ec2TagSet;
        this.onPremisesTagSet = builder.onPremisesTagSet;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String deploymentGroupName() {
        return this.deploymentGroupName;
    }

    public String deploymentConfigName() {
        return this.deploymentConfigName;
    }

    public List<EC2TagFilter> ec2TagFilters() {
        return this.ec2TagFilters;
    }

    public List<TagFilter> onPremisesInstanceTagFilters() {
        return this.onPremisesInstanceTagFilters;
    }

    public List<String> autoScalingGroups() {
        return this.autoScalingGroups;
    }

    public String serviceRoleArn() {
        return this.serviceRoleArn;
    }

    public List<TriggerConfig> triggerConfigurations() {
        return this.triggerConfigurations;
    }

    public AlarmConfiguration alarmConfiguration() {
        return this.alarmConfiguration;
    }

    public AutoRollbackConfiguration autoRollbackConfiguration() {
        return this.autoRollbackConfiguration;
    }

    public DeploymentStyle deploymentStyle() {
        return this.deploymentStyle;
    }

    public BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration() {
        return this.blueGreenDeploymentConfiguration;
    }

    public LoadBalancerInfo loadBalancerInfo() {
        return this.loadBalancerInfo;
    }

    public EC2TagSet ec2TagSet() {
        return this.ec2TagSet;
    }

    public OnPremisesTagSet onPremisesTagSet() {
        return this.onPremisesTagSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2TagFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.onPremisesInstanceTagFilters());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoScalingGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentStyle());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueGreenDeploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.loadBalancerInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2TagSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.onPremisesTagSet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentGroupRequest)) {
            return false;
        }
        CreateDeploymentGroupRequest other = (CreateDeploymentGroupRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.deploymentGroupName(), other.deploymentGroupName()) && Objects.equals(this.deploymentConfigName(), other.deploymentConfigName()) && Objects.equals(this.ec2TagFilters(), other.ec2TagFilters()) && Objects.equals(this.onPremisesInstanceTagFilters(), other.onPremisesInstanceTagFilters()) && Objects.equals(this.autoScalingGroups(), other.autoScalingGroups()) && Objects.equals(this.serviceRoleArn(), other.serviceRoleArn()) && Objects.equals(this.triggerConfigurations(), other.triggerConfigurations()) && Objects.equals(this.alarmConfiguration(), other.alarmConfiguration()) && Objects.equals(this.autoRollbackConfiguration(), other.autoRollbackConfiguration()) && Objects.equals(this.deploymentStyle(), other.deploymentStyle()) && Objects.equals(this.blueGreenDeploymentConfiguration(), other.blueGreenDeploymentConfiguration()) && Objects.equals(this.loadBalancerInfo(), other.loadBalancerInfo()) && Objects.equals(this.ec2TagSet(), other.ec2TagSet()) && Objects.equals(this.onPremisesTagSet(), other.onPremisesTagSet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.applicationName() != null) {
            sb.append("ApplicationName: ").append(this.applicationName()).append(",");
        }
        if (this.deploymentGroupName() != null) {
            sb.append("DeploymentGroupName: ").append(this.deploymentGroupName()).append(",");
        }
        if (this.deploymentConfigName() != null) {
            sb.append("DeploymentConfigName: ").append(this.deploymentConfigName()).append(",");
        }
        if (this.ec2TagFilters() != null) {
            sb.append("Ec2TagFilters: ").append(this.ec2TagFilters()).append(",");
        }
        if (this.onPremisesInstanceTagFilters() != null) {
            sb.append("OnPremisesInstanceTagFilters: ").append(this.onPremisesInstanceTagFilters()).append(",");
        }
        if (this.autoScalingGroups() != null) {
            sb.append("AutoScalingGroups: ").append(this.autoScalingGroups()).append(",");
        }
        if (this.serviceRoleArn() != null) {
            sb.append("ServiceRoleArn: ").append(this.serviceRoleArn()).append(",");
        }
        if (this.triggerConfigurations() != null) {
            sb.append("TriggerConfigurations: ").append(this.triggerConfigurations()).append(",");
        }
        if (this.alarmConfiguration() != null) {
            sb.append("AlarmConfiguration: ").append(this.alarmConfiguration()).append(",");
        }
        if (this.autoRollbackConfiguration() != null) {
            sb.append("AutoRollbackConfiguration: ").append(this.autoRollbackConfiguration()).append(",");
        }
        if (this.deploymentStyle() != null) {
            sb.append("DeploymentStyle: ").append(this.deploymentStyle()).append(",");
        }
        if (this.blueGreenDeploymentConfiguration() != null) {
            sb.append("BlueGreenDeploymentConfiguration: ").append(this.blueGreenDeploymentConfiguration()).append(",");
        }
        if (this.loadBalancerInfo() != null) {
            sb.append("LoadBalancerInfo: ").append(this.loadBalancerInfo()).append(",");
        }
        if (this.ec2TagSet() != null) {
            sb.append("Ec2TagSet: ").append(this.ec2TagSet()).append(",");
        }
        if (this.onPremisesTagSet() != null) {
            sb.append("OnPremisesTagSet: ").append(this.onPremisesTagSet()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "deploymentGroupName": {
                return Optional.of(clazz.cast(this.deploymentGroupName()));
            }
            case "deploymentConfigName": {
                return Optional.of(clazz.cast(this.deploymentConfigName()));
            }
            case "ec2TagFilters": {
                return Optional.of(clazz.cast(this.ec2TagFilters()));
            }
            case "onPremisesInstanceTagFilters": {
                return Optional.of(clazz.cast(this.onPremisesInstanceTagFilters()));
            }
            case "autoScalingGroups": {
                return Optional.of(clazz.cast(this.autoScalingGroups()));
            }
            case "serviceRoleArn": {
                return Optional.of(clazz.cast(this.serviceRoleArn()));
            }
            case "triggerConfigurations": {
                return Optional.of(clazz.cast(this.triggerConfigurations()));
            }
            case "alarmConfiguration": {
                return Optional.of(clazz.cast(this.alarmConfiguration()));
            }
            case "autoRollbackConfiguration": {
                return Optional.of(clazz.cast(this.autoRollbackConfiguration()));
            }
            case "deploymentStyle": {
                return Optional.of(clazz.cast(this.deploymentStyle()));
            }
            case "blueGreenDeploymentConfiguration": {
                return Optional.of(clazz.cast(this.blueGreenDeploymentConfiguration()));
            }
            case "loadBalancerInfo": {
                return Optional.of(clazz.cast(this.loadBalancerInfo()));
            }
            case "ec2TagSet": {
                return Optional.of(clazz.cast(this.ec2TagSet()));
            }
            case "onPremisesTagSet": {
                return Optional.of(clazz.cast(this.onPremisesTagSet()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String applicationName;
        private String deploymentGroupName;
        private String deploymentConfigName;
        private List<EC2TagFilter> ec2TagFilters;
        private List<TagFilter> onPremisesInstanceTagFilters;
        private List<String> autoScalingGroups;
        private String serviceRoleArn;
        private List<TriggerConfig> triggerConfigurations;
        private AlarmConfiguration alarmConfiguration;
        private AutoRollbackConfiguration autoRollbackConfiguration;
        private DeploymentStyle deploymentStyle;
        private BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration;
        private LoadBalancerInfo loadBalancerInfo;
        private EC2TagSet ec2TagSet;
        private OnPremisesTagSet onPremisesTagSet;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentGroupRequest model) {
            this.applicationName(model.applicationName);
            this.deploymentGroupName(model.deploymentGroupName);
            this.deploymentConfigName(model.deploymentConfigName);
            this.ec2TagFilters(model.ec2TagFilters);
            this.onPremisesInstanceTagFilters(model.onPremisesInstanceTagFilters);
            this.autoScalingGroups(model.autoScalingGroups);
            this.serviceRoleArn(model.serviceRoleArn);
            this.triggerConfigurations(model.triggerConfigurations);
            this.alarmConfiguration(model.alarmConfiguration);
            this.autoRollbackConfiguration(model.autoRollbackConfiguration);
            this.deploymentStyle(model.deploymentStyle);
            this.blueGreenDeploymentConfiguration(model.blueGreenDeploymentConfiguration);
            this.loadBalancerInfo(model.loadBalancerInfo);
            this.ec2TagSet(model.ec2TagSet);
            this.onPremisesTagSet(model.onPremisesTagSet);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        public final String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final Collection<EC2TagFilter.Builder> getEc2TagFilters() {
            return this.ec2TagFilters != null ? (Collection)this.ec2TagFilters.stream().map(EC2TagFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ec2TagFilters(Collection<EC2TagFilter> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copy(ec2TagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2TagFilters(EC2TagFilter ... ec2TagFilters) {
            this.ec2TagFilters(Arrays.asList(ec2TagFilters));
            return this;
        }

        public final void setEc2TagFilters(Collection<EC2TagFilter.BuilderImpl> ec2TagFilters) {
            this.ec2TagFilters = EC2TagFilterListCopier.copyFromBuilder(ec2TagFilters);
        }

        public final Collection<TagFilter.Builder> getOnPremisesInstanceTagFilters() {
            return this.onPremisesInstanceTagFilters != null ? (Collection)this.onPremisesInstanceTagFilters.stream().map(TagFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder onPremisesInstanceTagFilters(Collection<TagFilter> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copy(onPremisesInstanceTagFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onPremisesInstanceTagFilters(TagFilter ... onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters(Arrays.asList(onPremisesInstanceTagFilters));
            return this;
        }

        public final void setOnPremisesInstanceTagFilters(Collection<TagFilter.BuilderImpl> onPremisesInstanceTagFilters) {
            this.onPremisesInstanceTagFilters = TagFilterListCopier.copyFromBuilder(onPremisesInstanceTagFilters);
        }

        public final Collection<String> getAutoScalingGroups() {
            return this.autoScalingGroups;
        }

        @Override
        public final Builder autoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autoScalingGroups(String ... autoScalingGroups) {
            this.autoScalingGroups(Arrays.asList(autoScalingGroups));
            return this;
        }

        public final void setAutoScalingGroups(Collection<String> autoScalingGroups) {
            this.autoScalingGroups = AutoScalingGroupNameListCopier.copy(autoScalingGroups);
        }

        public final String getServiceRoleArn() {
            return this.serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final Collection<TriggerConfig.Builder> getTriggerConfigurations() {
            return this.triggerConfigurations != null ? (Collection)this.triggerConfigurations.stream().map(TriggerConfig::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder triggerConfigurations(Collection<TriggerConfig> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copy(triggerConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerConfigurations(TriggerConfig ... triggerConfigurations) {
            this.triggerConfigurations(Arrays.asList(triggerConfigurations));
            return this;
        }

        public final void setTriggerConfigurations(Collection<TriggerConfig.BuilderImpl> triggerConfigurations) {
            this.triggerConfigurations = TriggerConfigListCopier.copyFromBuilder(triggerConfigurations);
        }

        public final AlarmConfiguration.Builder getAlarmConfiguration() {
            return this.alarmConfiguration != null ? this.alarmConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder alarmConfiguration(AlarmConfiguration alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration;
            return this;
        }

        public final void setAlarmConfiguration(AlarmConfiguration.BuilderImpl alarmConfiguration) {
            this.alarmConfiguration = alarmConfiguration != null ? alarmConfiguration.build() : null;
        }

        public final AutoRollbackConfiguration.Builder getAutoRollbackConfiguration() {
            return this.autoRollbackConfiguration != null ? this.autoRollbackConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration.BuilderImpl autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration != null ? autoRollbackConfiguration.build() : null;
        }

        public final DeploymentStyle.Builder getDeploymentStyle() {
            return this.deploymentStyle != null ? this.deploymentStyle.toBuilder() : null;
        }

        @Override
        public final Builder deploymentStyle(DeploymentStyle deploymentStyle) {
            this.deploymentStyle = deploymentStyle;
            return this;
        }

        public final void setDeploymentStyle(DeploymentStyle.BuilderImpl deploymentStyle) {
            this.deploymentStyle = deploymentStyle != null ? deploymentStyle.build() : null;
        }

        public final BlueGreenDeploymentConfiguration.Builder getBlueGreenDeploymentConfiguration() {
            return this.blueGreenDeploymentConfiguration != null ? this.blueGreenDeploymentConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration;
            return this;
        }

        public final void setBlueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration.BuilderImpl blueGreenDeploymentConfiguration) {
            this.blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration != null ? blueGreenDeploymentConfiguration.build() : null;
        }

        public final LoadBalancerInfo.Builder getLoadBalancerInfo() {
            return this.loadBalancerInfo != null ? this.loadBalancerInfo.toBuilder() : null;
        }

        @Override
        public final Builder loadBalancerInfo(LoadBalancerInfo loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo;
            return this;
        }

        public final void setLoadBalancerInfo(LoadBalancerInfo.BuilderImpl loadBalancerInfo) {
            this.loadBalancerInfo = loadBalancerInfo != null ? loadBalancerInfo.build() : null;
        }

        public final EC2TagSet.Builder getEc2TagSet() {
            return this.ec2TagSet != null ? this.ec2TagSet.toBuilder() : null;
        }

        @Override
        public final Builder ec2TagSet(EC2TagSet ec2TagSet) {
            this.ec2TagSet = ec2TagSet;
            return this;
        }

        public final void setEc2TagSet(EC2TagSet.BuilderImpl ec2TagSet) {
            this.ec2TagSet = ec2TagSet != null ? ec2TagSet.build() : null;
        }

        public final OnPremisesTagSet.Builder getOnPremisesTagSet() {
            return this.onPremisesTagSet != null ? this.onPremisesTagSet.toBuilder() : null;
        }

        @Override
        public final Builder onPremisesTagSet(OnPremisesTagSet onPremisesTagSet) {
            this.onPremisesTagSet = onPremisesTagSet;
            return this;
        }

        public final void setOnPremisesTagSet(OnPremisesTagSet.BuilderImpl onPremisesTagSet) {
            this.onPremisesTagSet = onPremisesTagSet != null ? onPremisesTagSet.build() : null;
        }

        public CreateDeploymentGroupRequest build() {
            return new CreateDeploymentGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateDeploymentGroupRequest> {
        public Builder applicationName(String var1);

        public Builder deploymentGroupName(String var1);

        public Builder deploymentConfigName(String var1);

        public Builder ec2TagFilters(Collection<EC2TagFilter> var1);

        public Builder ec2TagFilters(EC2TagFilter ... var1);

        public Builder onPremisesInstanceTagFilters(Collection<TagFilter> var1);

        public Builder onPremisesInstanceTagFilters(TagFilter ... var1);

        public Builder autoScalingGroups(Collection<String> var1);

        public Builder autoScalingGroups(String ... var1);

        public Builder serviceRoleArn(String var1);

        public Builder triggerConfigurations(Collection<TriggerConfig> var1);

        public Builder triggerConfigurations(TriggerConfig ... var1);

        public Builder alarmConfiguration(AlarmConfiguration var1);

        default public Builder alarmConfiguration(Consumer<AlarmConfiguration.Builder> alarmConfiguration) {
            return this.alarmConfiguration((AlarmConfiguration)((AlarmConfiguration.Builder)AlarmConfiguration.builder().apply(alarmConfiguration)).build());
        }

        public Builder autoRollbackConfiguration(AutoRollbackConfiguration var1);

        default public Builder autoRollbackConfiguration(Consumer<AutoRollbackConfiguration.Builder> autoRollbackConfiguration) {
            return this.autoRollbackConfiguration((AutoRollbackConfiguration)((AutoRollbackConfiguration.Builder)AutoRollbackConfiguration.builder().apply(autoRollbackConfiguration)).build());
        }

        public Builder deploymentStyle(DeploymentStyle var1);

        default public Builder deploymentStyle(Consumer<DeploymentStyle.Builder> deploymentStyle) {
            return this.deploymentStyle((DeploymentStyle)((DeploymentStyle.Builder)DeploymentStyle.builder().apply(deploymentStyle)).build());
        }

        public Builder blueGreenDeploymentConfiguration(BlueGreenDeploymentConfiguration var1);

        default public Builder blueGreenDeploymentConfiguration(Consumer<BlueGreenDeploymentConfiguration.Builder> blueGreenDeploymentConfiguration) {
            return this.blueGreenDeploymentConfiguration((BlueGreenDeploymentConfiguration)((BlueGreenDeploymentConfiguration.Builder)BlueGreenDeploymentConfiguration.builder().apply(blueGreenDeploymentConfiguration)).build());
        }

        public Builder loadBalancerInfo(LoadBalancerInfo var1);

        default public Builder loadBalancerInfo(Consumer<LoadBalancerInfo.Builder> loadBalancerInfo) {
            return this.loadBalancerInfo((LoadBalancerInfo)((LoadBalancerInfo.Builder)LoadBalancerInfo.builder().apply(loadBalancerInfo)).build());
        }

        public Builder ec2TagSet(EC2TagSet var1);

        default public Builder ec2TagSet(Consumer<EC2TagSet.Builder> ec2TagSet) {
            return this.ec2TagSet((EC2TagSet)((EC2TagSet.Builder)EC2TagSet.builder().apply(ec2TagSet)).build());
        }

        public Builder onPremisesTagSet(OnPremisesTagSet var1);

        default public Builder onPremisesTagSet(Consumer<OnPremisesTagSet.Builder> onPremisesTagSet) {
            return this.onPremisesTagSet((OnPremisesTagSet)((OnPremisesTagSet.Builder)OnPremisesTagSet.builder().apply(onPremisesTagSet)).build());
        }
    }
}

