/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.InstanceSummary;

@SdkInternalApi
public class InstanceSummaryMarshaller {
    private static final MarshallingInfo<String> DEPLOYMENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentId").build();
    private static final MarshallingInfo<String> INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceId").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<Instant> LASTUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastUpdatedAt").build();
    private static final MarshallingInfo<List> LIFECYCLEEVENTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lifecycleEvents").build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("instanceType").build();
    private static final InstanceSummaryMarshaller INSTANCE = new InstanceSummaryMarshaller();

    public static InstanceSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(InstanceSummary instanceSummary, ProtocolMarshaller protocolMarshaller) {
        if (instanceSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instanceSummary.deploymentId(), DEPLOYMENTID_BINDING);
            protocolMarshaller.marshall((Object)instanceSummary.instanceId(), INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)instanceSummary.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)instanceSummary.lastUpdatedAt(), LASTUPDATEDAT_BINDING);
            protocolMarshaller.marshall(instanceSummary.lifecycleEvents(), LIFECYCLEEVENTS_BINDING);
            protocolMarshaller.marshall((Object)instanceSummary.instanceTypeString(), INSTANCETYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

