/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.GitHubLocation;

@SdkInternalApi
public class GitHubLocationMarshaller {
    private static final MarshallingInfo<String> REPOSITORY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("repository").build();
    private static final MarshallingInfo<String> COMMITID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("commitId").build();
    private static final GitHubLocationMarshaller INSTANCE = new GitHubLocationMarshaller();

    public static GitHubLocationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(GitHubLocation gitHubLocation, ProtocolMarshaller protocolMarshaller) {
        if (gitHubLocation == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)gitHubLocation.repository(), REPOSITORY_BINDING);
            protocolMarshaller.marshall((Object)gitHubLocation.commitId(), COMMITID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

