/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.ELBInfo;
import software.amazon.awssdk.services.codedeploy.model.ELBInfoListCopier;
import software.amazon.awssdk.services.codedeploy.transform.LoadBalancerInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class LoadBalancerInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, LoadBalancerInfo> {
    private final List<ELBInfo> elbInfoList;

    private LoadBalancerInfo(BuilderImpl builder) {
        this.elbInfoList = builder.elbInfoList;
    }

    public List<ELBInfo> elbInfoList() {
        return this.elbInfoList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.elbInfoList() == null ? 0 : this.elbInfoList().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoadBalancerInfo)) {
            return false;
        }
        LoadBalancerInfo other = (LoadBalancerInfo)obj;
        if (other.elbInfoList() == null ^ this.elbInfoList() == null) {
            return false;
        }
        return other.elbInfoList() == null || other.elbInfoList().equals(this.elbInfoList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.elbInfoList() != null) {
            sb.append("ElbInfoList: ").append(this.elbInfoList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "elbInfoList": {
                return Optional.of(clazz.cast(this.elbInfoList()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        LoadBalancerInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ELBInfo> elbInfoList;

        private BuilderImpl() {
        }

        private BuilderImpl(LoadBalancerInfo model) {
            this.elbInfoList(model.elbInfoList);
        }

        public final Collection<ELBInfo.Builder> getElbInfoList() {
            return this.elbInfoList != null ? (Collection)this.elbInfoList.stream().map(ELBInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elbInfoList(Collection<ELBInfo> elbInfoList) {
            this.elbInfoList = ELBInfoListCopier.copy(elbInfoList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elbInfoList(ELBInfo ... elbInfoList) {
            this.elbInfoList(Arrays.asList(elbInfoList));
            return this;
        }

        public final void setElbInfoList(Collection<ELBInfo.BuilderImpl> elbInfoList) {
            this.elbInfoList = ELBInfoListCopier.copyFromBuilder(elbInfoList);
        }

        public LoadBalancerInfo build() {
            return new LoadBalancerInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, LoadBalancerInfo> {
        public Builder elbInfoList(Collection<ELBInfo> var1);

        public Builder elbInfoList(ELBInfo ... var1);
    }
}

