/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.TrafficRoutingConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class TrafficRoutingConfigMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("type").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TIMEBASEDCANARY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeBasedCanary").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TIMEBASEDLINEAR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("timeBasedLinear").isBinary(false).build();
    private static final TrafficRoutingConfigMarshaller INSTANCE = new TrafficRoutingConfigMarshaller();

    private TrafficRoutingConfigMarshaller() {
    }

    public static TrafficRoutingConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TrafficRoutingConfig trafficRoutingConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)trafficRoutingConfig, (String)"trafficRoutingConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)trafficRoutingConfig.typeAsString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)trafficRoutingConfig.timeBasedCanary(), TIMEBASEDCANARY_BINDING);
            protocolMarshaller.marshall((Object)trafficRoutingConfig.timeBasedLinear(), TIMEBASEDLINEAR_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

