/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.RawString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class RawStringMarshaller {
    private static final MarshallingInfo<String> CONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("content").isBinary(false).build();
    private static final MarshallingInfo<String> SHA256_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sha256").isBinary(false).build();
    private static final RawStringMarshaller INSTANCE = new RawStringMarshaller();

    private RawStringMarshaller() {
    }

    public static RawStringMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(RawString rawString, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)rawString, (String)"rawString");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)rawString.content(), CONTENT_BINDING);
            protocolMarshaller.marshall((Object)rawString.sha256(), SHA256_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

