/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.transform.TimeBasedLinearMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TimeBasedLinear
implements StructuredPojo,
ToCopyableBuilder<Builder, TimeBasedLinear> {
    private final Integer linearPercentage;
    private final Integer linearInterval;

    private TimeBasedLinear(BuilderImpl builder) {
        this.linearPercentage = builder.linearPercentage;
        this.linearInterval = builder.linearInterval;
    }

    public Integer linearPercentage() {
        return this.linearPercentage;
    }

    public Integer linearInterval() {
        return this.linearInterval;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.linearPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.linearInterval());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeBasedLinear)) {
            return false;
        }
        TimeBasedLinear other = (TimeBasedLinear)obj;
        return Objects.equals(this.linearPercentage(), other.linearPercentage()) && Objects.equals(this.linearInterval(), other.linearInterval());
    }

    public String toString() {
        return ToString.builder((String)"TimeBasedLinear").add("LinearPercentage", (Object)this.linearPercentage()).add("LinearInterval", (Object)this.linearInterval()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "linearPercentage": {
                return Optional.ofNullable(clazz.cast(this.linearPercentage()));
            }
            case "linearInterval": {
                return Optional.ofNullable(clazz.cast(this.linearInterval()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimeBasedLinearMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer linearPercentage;
        private Integer linearInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeBasedLinear model) {
            this.linearPercentage(model.linearPercentage);
            this.linearInterval(model.linearInterval);
        }

        public final Integer getLinearPercentage() {
            return this.linearPercentage;
        }

        @Override
        public final Builder linearPercentage(Integer linearPercentage) {
            this.linearPercentage = linearPercentage;
            return this;
        }

        public final void setLinearPercentage(Integer linearPercentage) {
            this.linearPercentage = linearPercentage;
        }

        public final Integer getLinearInterval() {
            return this.linearInterval;
        }

        @Override
        public final Builder linearInterval(Integer linearInterval) {
            this.linearInterval = linearInterval;
            return this;
        }

        public final void setLinearInterval(Integer linearInterval) {
            this.linearInterval = linearInterval;
        }

        public TimeBasedLinear build() {
            return new TimeBasedLinear(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TimeBasedLinear> {
        public Builder linearPercentage(Integer var1);

        public Builder linearInterval(Integer var1);
    }
}

