/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.ComputePlatform;
import software.amazon.awssdk.services.codedeploy.model.MinimumHealthyHosts;
import software.amazon.awssdk.services.codedeploy.model.TrafficRoutingConfig;
import software.amazon.awssdk.services.codedeploy.transform.DeploymentConfigInfoMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentConfigInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, DeploymentConfigInfo> {
    private final String deploymentConfigId;
    private final String deploymentConfigName;
    private final MinimumHealthyHosts minimumHealthyHosts;
    private final Instant createTime;
    private final String computePlatform;
    private final TrafficRoutingConfig trafficRoutingConfig;

    private DeploymentConfigInfo(BuilderImpl builder) {
        this.deploymentConfigId = builder.deploymentConfigId;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.minimumHealthyHosts = builder.minimumHealthyHosts;
        this.createTime = builder.createTime;
        this.computePlatform = builder.computePlatform;
        this.trafficRoutingConfig = builder.trafficRoutingConfig;
    }

    public String deploymentConfigId() {
        return this.deploymentConfigId;
    }

    public String deploymentConfigName() {
        return this.deploymentConfigName;
    }

    public MinimumHealthyHosts minimumHealthyHosts() {
        return this.minimumHealthyHosts;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public ComputePlatform computePlatform() {
        return ComputePlatform.fromValue(this.computePlatform);
    }

    public String computePlatformAsString() {
        return this.computePlatform;
    }

    public TrafficRoutingConfig trafficRoutingConfig() {
        return this.trafficRoutingConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumHealthyHosts());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.computePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficRoutingConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentConfigInfo)) {
            return false;
        }
        DeploymentConfigInfo other = (DeploymentConfigInfo)obj;
        return Objects.equals(this.deploymentConfigId(), other.deploymentConfigId()) && Objects.equals(this.deploymentConfigName(), other.deploymentConfigName()) && Objects.equals(this.minimumHealthyHosts(), other.minimumHealthyHosts()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.computePlatformAsString(), other.computePlatformAsString()) && Objects.equals(this.trafficRoutingConfig(), other.trafficRoutingConfig());
    }

    public String toString() {
        return ToString.builder((String)"DeploymentConfigInfo").add("DeploymentConfigId", (Object)this.deploymentConfigId()).add("DeploymentConfigName", (Object)this.deploymentConfigName()).add("MinimumHealthyHosts", (Object)this.minimumHealthyHosts()).add("CreateTime", (Object)this.createTime()).add("ComputePlatform", (Object)this.computePlatformAsString()).add("TrafficRoutingConfig", (Object)this.trafficRoutingConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentConfigId": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfigId()));
            }
            case "deploymentConfigName": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfigName()));
            }
            case "minimumHealthyHosts": {
                return Optional.ofNullable(clazz.cast(this.minimumHealthyHosts()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "computePlatform": {
                return Optional.ofNullable(clazz.cast(this.computePlatformAsString()));
            }
            case "trafficRoutingConfig": {
                return Optional.ofNullable(clazz.cast(this.trafficRoutingConfig()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentConfigInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentConfigId;
        private String deploymentConfigName;
        private MinimumHealthyHosts minimumHealthyHosts;
        private Instant createTime;
        private String computePlatform;
        private TrafficRoutingConfig trafficRoutingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentConfigInfo model) {
            this.deploymentConfigId(model.deploymentConfigId);
            this.deploymentConfigName(model.deploymentConfigName);
            this.minimumHealthyHosts(model.minimumHealthyHosts);
            this.createTime(model.createTime);
            this.computePlatform(model.computePlatform);
            this.trafficRoutingConfig(model.trafficRoutingConfig);
        }

        public final String getDeploymentConfigId() {
            return this.deploymentConfigId;
        }

        @Override
        public final Builder deploymentConfigId(String deploymentConfigId) {
            this.deploymentConfigId = deploymentConfigId;
            return this;
        }

        public final void setDeploymentConfigId(String deploymentConfigId) {
            this.deploymentConfigId = deploymentConfigId;
        }

        public final String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        public final MinimumHealthyHosts.Builder getMinimumHealthyHosts() {
            return this.minimumHealthyHosts != null ? this.minimumHealthyHosts.toBuilder() : null;
        }

        @Override
        public final Builder minimumHealthyHosts(MinimumHealthyHosts minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts;
            return this;
        }

        public final void setMinimumHealthyHosts(MinimumHealthyHosts.BuilderImpl minimumHealthyHosts) {
            this.minimumHealthyHosts = minimumHealthyHosts != null ? minimumHealthyHosts.build() : null;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final String getComputePlatform() {
            return this.computePlatform;
        }

        @Override
        public final Builder computePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
            return this;
        }

        @Override
        public final Builder computePlatform(ComputePlatform computePlatform) {
            this.computePlatform(computePlatform.toString());
            return this;
        }

        public final void setComputePlatform(String computePlatform) {
            this.computePlatform = computePlatform;
        }

        public final TrafficRoutingConfig.Builder getTrafficRoutingConfig() {
            return this.trafficRoutingConfig != null ? this.trafficRoutingConfig.toBuilder() : null;
        }

        @Override
        public final Builder trafficRoutingConfig(TrafficRoutingConfig trafficRoutingConfig) {
            this.trafficRoutingConfig = trafficRoutingConfig;
            return this;
        }

        public final void setTrafficRoutingConfig(TrafficRoutingConfig.BuilderImpl trafficRoutingConfig) {
            this.trafficRoutingConfig = trafficRoutingConfig != null ? trafficRoutingConfig.build() : null;
        }

        public DeploymentConfigInfo build() {
            return new DeploymentConfigInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeploymentConfigInfo> {
        public Builder deploymentConfigId(String var1);

        public Builder deploymentConfigName(String var1);

        public Builder minimumHealthyHosts(MinimumHealthyHosts var1);

        default public Builder minimumHealthyHosts(Consumer<MinimumHealthyHosts.Builder> minimumHealthyHosts) {
            return this.minimumHealthyHosts((MinimumHealthyHosts)((MinimumHealthyHosts.Builder)MinimumHealthyHosts.builder().applyMutation(minimumHealthyHosts)).build());
        }

        public Builder createTime(Instant var1);

        public Builder computePlatform(String var1);

        public Builder computePlatform(ComputePlatform var1);

        public Builder trafficRoutingConfig(TrafficRoutingConfig var1);

        default public Builder trafficRoutingConfig(Consumer<TrafficRoutingConfig.Builder> trafficRoutingConfig) {
            return this.trafficRoutingConfig((TrafficRoutingConfig)((TrafficRoutingConfig.Builder)TrafficRoutingConfig.builder().applyMutation(trafficRoutingConfig)).build());
        }
    }
}

