/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.codedeploy.model.DeploymentOverview;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class DeploymentOverviewMarshaller {
    private static final MarshallingInfo<Long> PENDING_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Pending").isBinary(false).build();
    private static final MarshallingInfo<Long> INPROGRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InProgress").isBinary(false).build();
    private static final MarshallingInfo<Long> SUCCEEDED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Succeeded").isBinary(false).build();
    private static final MarshallingInfo<Long> FAILED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Failed").isBinary(false).build();
    private static final MarshallingInfo<Long> SKIPPED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Skipped").isBinary(false).build();
    private static final MarshallingInfo<Long> READY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ready").isBinary(false).build();
    private static final DeploymentOverviewMarshaller INSTANCE = new DeploymentOverviewMarshaller();

    private DeploymentOverviewMarshaller() {
    }

    public static DeploymentOverviewMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DeploymentOverview deploymentOverview, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)deploymentOverview, (String)"deploymentOverview");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)deploymentOverview.pending(), PENDING_BINDING);
            protocolMarshaller.marshall((Object)deploymentOverview.inProgress(), INPROGRESS_BINDING);
            protocolMarshaller.marshall((Object)deploymentOverview.succeeded(), SUCCEEDED_BINDING);
            protocolMarshaller.marshall((Object)deploymentOverview.failed(), FAILED_BINDING);
            protocolMarshaller.marshall((Object)deploymentOverview.skipped(), SKIPPED_BINDING);
            protocolMarshaller.marshall((Object)deploymentOverview.ready(), READY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

