/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.codedeploy.model.CreateDeploymentRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateDeploymentRequestModelMarshaller {
    private static final MarshallingInfo<String> APPLICATIONNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("applicationName").isBinary(false).build();
    private static final MarshallingInfo<String> DEPLOYMENTGROUPNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentGroupName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> REVISION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("revision").isBinary(false).build();
    private static final MarshallingInfo<String> DEPLOYMENTCONFIGNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("deploymentConfigName").isBinary(false).build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").isBinary(false).build();
    private static final MarshallingInfo<Boolean> IGNOREAPPLICATIONSTOPFAILURES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ignoreApplicationStopFailures").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TARGETINSTANCES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetInstances").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> AUTOROLLBACKCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("autoRollbackConfiguration").isBinary(false).build();
    private static final MarshallingInfo<Boolean> UPDATEOUTDATEDINSTANCESONLY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("updateOutdatedInstancesOnly").isBinary(false).build();
    private static final MarshallingInfo<String> FILEEXISTSBEHAVIOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileExistsBehavior").isBinary(false).build();
    private static final CreateDeploymentRequestModelMarshaller INSTANCE = new CreateDeploymentRequestModelMarshaller();

    private CreateDeploymentRequestModelMarshaller() {
    }

    public static CreateDeploymentRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CreateDeploymentRequest createDeploymentRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)createDeploymentRequest), (String)"createDeploymentRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)createDeploymentRequest.applicationName(), APPLICATIONNAME_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.deploymentGroupName(), DEPLOYMENTGROUPNAME_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.revision(), REVISION_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.deploymentConfigName(), DEPLOYMENTCONFIGNAME_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.ignoreApplicationStopFailures(), IGNOREAPPLICATIONSTOPFAILURES_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.targetInstances(), TARGETINSTANCES_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.autoRollbackConfiguration(), AUTOROLLBACKCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.updateOutdatedInstancesOnly(), UPDATEOUTDATEDINSTANCESONLY_BINDING);
            protocolMarshaller.marshall((Object)createDeploymentRequest.fileExistsBehaviorAsString(), FILEEXISTSBEHAVIOR_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

