/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateApplicationRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, UpdateApplicationRequest> {
    private final String applicationName;
    private final String newApplicationName;

    private UpdateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.newApplicationName = builder.newApplicationName;
    }

    public String applicationName() {
        return this.applicationName;
    }

    public String newApplicationName() {
        return this.newApplicationName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.newApplicationName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateApplicationRequest)) {
            return false;
        }
        UpdateApplicationRequest other = (UpdateApplicationRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.newApplicationName(), other.newApplicationName());
    }

    public String toString() {
        return ToString.builder((String)"UpdateApplicationRequest").add("ApplicationName", (Object)this.applicationName()).add("NewApplicationName", (Object)this.newApplicationName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.of(clazz.cast(this.applicationName()));
            }
            case "newApplicationName": {
                return Optional.of(clazz.cast(this.newApplicationName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String newApplicationName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateApplicationRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.newApplicationName(model.newApplicationName);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        public final String getNewApplicationName() {
            return this.newApplicationName;
        }

        @Override
        public final Builder newApplicationName(String newApplicationName) {
            this.newApplicationName = newApplicationName;
            return this;
        }

        public final void setNewApplicationName(String newApplicationName) {
            this.newApplicationName = newApplicationName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateApplicationRequest build() {
            return new UpdateApplicationRequest(this);
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    CopyableBuilder<Builder, UpdateApplicationRequest> {
        public Builder applicationName(String var1);

        public Builder newApplicationName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

