/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.services.codedeploy.model.TriggerEventType;
import software.amazon.awssdk.services.codedeploy.model.TriggerEventTypeListCopier;
import software.amazon.awssdk.services.codedeploy.transform.TriggerConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TriggerConfig
implements StructuredPojo,
ToCopyableBuilder<Builder, TriggerConfig> {
    private final String triggerName;
    private final String triggerTargetArn;
    private final List<String> triggerEvents;

    private TriggerConfig(BuilderImpl builder) {
        this.triggerName = builder.triggerName;
        this.triggerTargetArn = builder.triggerTargetArn;
        this.triggerEvents = builder.triggerEvents;
    }

    public String triggerName() {
        return this.triggerName;
    }

    public String triggerTargetArn() {
        return this.triggerTargetArn;
    }

    public List<TriggerEventType> triggerEvents() {
        return TypeConverter.convert(this.triggerEvents, TriggerEventType::fromValue);
    }

    public List<String> triggerEventsAsStrings() {
        return this.triggerEvents;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerTargetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerEventsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriggerConfig)) {
            return false;
        }
        TriggerConfig other = (TriggerConfig)obj;
        return Objects.equals(this.triggerName(), other.triggerName()) && Objects.equals(this.triggerTargetArn(), other.triggerTargetArn()) && Objects.equals(this.triggerEventsAsStrings(), other.triggerEventsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"TriggerConfig").add("TriggerName", (Object)this.triggerName()).add("TriggerTargetArn", (Object)this.triggerTargetArn()).add("TriggerEvents", this.triggerEventsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "triggerName": {
                return Optional.of(clazz.cast(this.triggerName()));
            }
            case "triggerTargetArn": {
                return Optional.of(clazz.cast(this.triggerTargetArn()));
            }
            case "triggerEvents": {
                return Optional.of(clazz.cast(this.triggerEventsAsStrings()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TriggerConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String triggerName;
        private String triggerTargetArn;
        private List<String> triggerEvents;

        private BuilderImpl() {
        }

        private BuilderImpl(TriggerConfig model) {
            this.triggerName(model.triggerName);
            this.triggerTargetArn(model.triggerTargetArn);
            this.triggerEvents(model.triggerEvents);
        }

        public final String getTriggerName() {
            return this.triggerName;
        }

        @Override
        public final Builder triggerName(String triggerName) {
            this.triggerName = triggerName;
            return this;
        }

        public final void setTriggerName(String triggerName) {
            this.triggerName = triggerName;
        }

        public final String getTriggerTargetArn() {
            return this.triggerTargetArn;
        }

        @Override
        public final Builder triggerTargetArn(String triggerTargetArn) {
            this.triggerTargetArn = triggerTargetArn;
            return this;
        }

        public final void setTriggerTargetArn(String triggerTargetArn) {
            this.triggerTargetArn = triggerTargetArn;
        }

        public final Collection<String> getTriggerEvents() {
            return this.triggerEvents;
        }

        @Override
        public final Builder triggerEvents(Collection<String> triggerEvents) {
            this.triggerEvents = TriggerEventTypeListCopier.copy(triggerEvents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerEvents(String ... triggerEvents) {
            this.triggerEvents(Arrays.asList(triggerEvents));
            return this;
        }

        public final void setTriggerEvents(Collection<String> triggerEvents) {
            this.triggerEvents = TriggerEventTypeListCopier.copy(triggerEvents);
        }

        public TriggerConfig build() {
            return new TriggerConfig(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TriggerConfig> {
        public Builder triggerName(String var1);

        public Builder triggerTargetArn(String var1);

        public Builder triggerEvents(Collection<String> var1);

        public Builder triggerEvents(String ... var1);
    }
}

