/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.codedeploy.model.Tag;
import software.amazon.awssdk.services.codedeploy.model.TagListCopier;
import software.amazon.awssdk.services.codedeploy.transform.InstanceInfoMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceInfo
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceInfo> {
    private final String instanceName;
    private final String iamSessionArn;
    private final String iamUserArn;
    private final String instanceArn;
    private final Date registerTime;
    private final Date deregisterTime;
    private final List<Tag> tags;

    private InstanceInfo(BuilderImpl builder) {
        this.instanceName = builder.instanceName;
        this.iamSessionArn = builder.iamSessionArn;
        this.iamUserArn = builder.iamUserArn;
        this.instanceArn = builder.instanceArn;
        this.registerTime = builder.registerTime;
        this.deregisterTime = builder.deregisterTime;
        this.tags = builder.tags;
    }

    public String instanceName() {
        return this.instanceName;
    }

    public String iamSessionArn() {
        return this.iamSessionArn;
    }

    public String iamUserArn() {
        return this.iamUserArn;
    }

    public String instanceArn() {
        return this.instanceArn;
    }

    public Date registerTime() {
        return this.registerTime;
    }

    public Date deregisterTime() {
        return this.deregisterTime;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceName() == null ? 0 : this.instanceName().hashCode());
        hashCode = 31 * hashCode + (this.iamSessionArn() == null ? 0 : this.iamSessionArn().hashCode());
        hashCode = 31 * hashCode + (this.iamUserArn() == null ? 0 : this.iamUserArn().hashCode());
        hashCode = 31 * hashCode + (this.instanceArn() == null ? 0 : this.instanceArn().hashCode());
        hashCode = 31 * hashCode + (this.registerTime() == null ? 0 : this.registerTime().hashCode());
        hashCode = 31 * hashCode + (this.deregisterTime() == null ? 0 : this.deregisterTime().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceInfo)) {
            return false;
        }
        InstanceInfo other = (InstanceInfo)obj;
        if (other.instanceName() == null ^ this.instanceName() == null) {
            return false;
        }
        if (other.instanceName() != null && !other.instanceName().equals(this.instanceName())) {
            return false;
        }
        if (other.iamSessionArn() == null ^ this.iamSessionArn() == null) {
            return false;
        }
        if (other.iamSessionArn() != null && !other.iamSessionArn().equals(this.iamSessionArn())) {
            return false;
        }
        if (other.iamUserArn() == null ^ this.iamUserArn() == null) {
            return false;
        }
        if (other.iamUserArn() != null && !other.iamUserArn().equals(this.iamUserArn())) {
            return false;
        }
        if (other.instanceArn() == null ^ this.instanceArn() == null) {
            return false;
        }
        if (other.instanceArn() != null && !other.instanceArn().equals(this.instanceArn())) {
            return false;
        }
        if (other.registerTime() == null ^ this.registerTime() == null) {
            return false;
        }
        if (other.registerTime() != null && !other.registerTime().equals(this.registerTime())) {
            return false;
        }
        if (other.deregisterTime() == null ^ this.deregisterTime() == null) {
            return false;
        }
        if (other.deregisterTime() != null && !other.deregisterTime().equals(this.deregisterTime())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        return other.tags() == null || other.tags().equals(this.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceName() != null) {
            sb.append("InstanceName: ").append(this.instanceName()).append(",");
        }
        if (this.iamSessionArn() != null) {
            sb.append("IamSessionArn: ").append(this.iamSessionArn()).append(",");
        }
        if (this.iamUserArn() != null) {
            sb.append("IamUserArn: ").append(this.iamUserArn()).append(",");
        }
        if (this.instanceArn() != null) {
            sb.append("InstanceArn: ").append(this.instanceArn()).append(",");
        }
        if (this.registerTime() != null) {
            sb.append("RegisterTime: ").append(this.registerTime()).append(",");
        }
        if (this.deregisterTime() != null) {
            sb.append("DeregisterTime: ").append(this.deregisterTime()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceInfoMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String instanceName;
        private String iamSessionArn;
        private String iamUserArn;
        private String instanceArn;
        private Date registerTime;
        private Date deregisterTime;
        private List<Tag> tags = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceInfo model) {
            this.setInstanceName(model.instanceName);
            this.setIamSessionArn(model.iamSessionArn);
            this.setIamUserArn(model.iamUserArn);
            this.setInstanceArn(model.instanceArn);
            this.setRegisterTime(model.registerTime);
            this.setDeregisterTime(model.deregisterTime);
            this.setTags(model.tags);
        }

        public final String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public final String getIamSessionArn() {
            return this.iamSessionArn;
        }

        @Override
        public final Builder iamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
            return this;
        }

        public final void setIamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
        }

        public final String getIamUserArn() {
            return this.iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        public final Date getRegisterTime() {
            return this.registerTime;
        }

        @Override
        public final Builder registerTime(Date registerTime) {
            this.registerTime = StandardMemberCopier.copy((Date)registerTime);
            return this;
        }

        public final void setRegisterTime(Date registerTime) {
            this.registerTime = StandardMemberCopier.copy((Date)registerTime);
        }

        public final Date getDeregisterTime() {
            return this.deregisterTime;
        }

        @Override
        public final Builder deregisterTime(Date deregisterTime) {
            this.deregisterTime = StandardMemberCopier.copy((Date)deregisterTime);
            return this;
        }

        public final void setDeregisterTime(Date deregisterTime) {
            this.deregisterTime = StandardMemberCopier.copy((Date)deregisterTime);
        }

        public final Collection<Tag> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag ... tags) {
            if (this.tags == null) {
                this.tags = new SdkInternalList(tags.length);
            }
            for (Tag e : tags) {
                this.tags.add(e);
            }
        }

        public InstanceInfo build() {
            return new InstanceInfo(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceInfo> {
        public Builder instanceName(String var1);

        public Builder iamSessionArn(String var1);

        public Builder iamUserArn(String var1);

        public Builder instanceArn(String var1);

        public Builder registerTime(Date var1);

        public Builder deregisterTime(Date var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

