/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.codedeploy.model.DeploymentsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchGetDeploymentsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, BatchGetDeploymentsRequest> {
    private final List<String> deploymentIds;

    private BatchGetDeploymentsRequest(BuilderImpl builder) {
        this.deploymentIds = builder.deploymentIds;
    }

    public List<String> deploymentIds() {
        return this.deploymentIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deploymentIds() == null ? 0 : this.deploymentIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDeploymentsRequest)) {
            return false;
        }
        BatchGetDeploymentsRequest other = (BatchGetDeploymentsRequest)((Object)obj);
        if (other.deploymentIds() == null ^ this.deploymentIds() == null) {
            return false;
        }
        return other.deploymentIds() == null || other.deploymentIds().equals(this.deploymentIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deploymentIds() != null) {
            sb.append("DeploymentIds: ").append(this.deploymentIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> deploymentIds = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDeploymentsRequest model) {
            this.setDeploymentIds(model.deploymentIds);
        }

        public final Collection<String> getDeploymentIds() {
            return this.deploymentIds;
        }

        @Override
        public final Builder deploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = DeploymentsListCopier.copy(deploymentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentIds(String ... deploymentIds) {
            if (this.deploymentIds == null) {
                this.deploymentIds = new SdkInternalList(deploymentIds.length);
            }
            for (String e : deploymentIds) {
                this.deploymentIds.add(e);
            }
            return this;
        }

        public final void setDeploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = DeploymentsListCopier.copy(deploymentIds);
        }

        @SafeVarargs
        public final void setDeploymentIds(String ... deploymentIds) {
            if (this.deploymentIds == null) {
                this.deploymentIds = new SdkInternalList(deploymentIds.length);
            }
            for (String e : deploymentIds) {
                this.deploymentIds.add(e);
            }
        }

        public BatchGetDeploymentsRequest build() {
            return new BatchGetDeploymentsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchGetDeploymentsRequest> {
        public Builder deploymentIds(Collection<String> var1);

        public Builder deploymentIds(String ... var1);
    }
}

