/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeconnections.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeconnections.model.CodeConnectionsResponse;
import software.amazon.awssdk.services.codeconnections.model.SyncConfiguration;
import software.amazon.awssdk.services.codeconnections.model.SyncConfigurationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSyncConfigurationsResponse
extends CodeConnectionsResponse
implements ToCopyableBuilder<Builder, ListSyncConfigurationsResponse> {
    private static final SdkField<List<SyncConfiguration>> SYNC_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SyncConfigurations").getter(ListSyncConfigurationsResponse.getter(ListSyncConfigurationsResponse::syncConfigurations)).setter(ListSyncConfigurationsResponse.setter(Builder::syncConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SyncConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSyncConfigurationsResponse.getter(ListSyncConfigurationsResponse::nextToken)).setter(ListSyncConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNC_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSyncConfigurationsResponse.memberNameToFieldInitializer();
    private final List<SyncConfiguration> syncConfigurations;
    private final String nextToken;

    private ListSyncConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.syncConfigurations = builder.syncConfigurations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSyncConfigurations() {
        return this.syncConfigurations != null && !(this.syncConfigurations instanceof SdkAutoConstructList);
    }

    public final List<SyncConfiguration> syncConfigurations() {
        return this.syncConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSyncConfigurations() ? this.syncConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSyncConfigurationsResponse)) {
            return false;
        }
        ListSyncConfigurationsResponse other = (ListSyncConfigurationsResponse)((Object)obj);
        return this.hasSyncConfigurations() == other.hasSyncConfigurations() && Objects.equals(this.syncConfigurations(), other.syncConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSyncConfigurationsResponse").add("SyncConfigurations", this.hasSyncConfigurations() ? this.syncConfigurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SyncConfigurations": {
                return Optional.ofNullable(clazz.cast(this.syncConfigurations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SyncConfigurations", SYNC_CONFIGURATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSyncConfigurationsResponse, T> g) {
        return obj -> g.apply((ListSyncConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeConnectionsResponse.BuilderImpl
    implements Builder {
        private List<SyncConfiguration> syncConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSyncConfigurationsResponse model) {
            super(model);
            this.syncConfigurations(model.syncConfigurations);
            this.nextToken(model.nextToken);
        }

        public final List<SyncConfiguration.Builder> getSyncConfigurations() {
            List<SyncConfiguration.Builder> result = SyncConfigurationListCopier.copyToBuilder(this.syncConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSyncConfigurations(Collection<SyncConfiguration.BuilderImpl> syncConfigurations) {
            this.syncConfigurations = SyncConfigurationListCopier.copyFromBuilder(syncConfigurations);
        }

        @Override
        public final Builder syncConfigurations(Collection<SyncConfiguration> syncConfigurations) {
            this.syncConfigurations = SyncConfigurationListCopier.copy(syncConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder syncConfigurations(SyncConfiguration ... syncConfigurations) {
            this.syncConfigurations(Arrays.asList(syncConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder syncConfigurations(Consumer<SyncConfiguration.Builder> ... syncConfigurations) {
            this.syncConfigurations(Stream.of(syncConfigurations).map(c -> (SyncConfiguration)((SyncConfiguration.Builder)SyncConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSyncConfigurationsResponse build() {
            return new ListSyncConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeConnectionsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSyncConfigurationsResponse> {
        public Builder syncConfigurations(Collection<SyncConfiguration> var1);

        public Builder syncConfigurations(SyncConfiguration ... var1);

        public Builder syncConfigurations(Consumer<SyncConfiguration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

