/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeconnections.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeconnections.model.ResourceSyncEvent;
import software.amazon.awssdk.services.codeconnections.model.ResourceSyncEventListCopier;
import software.amazon.awssdk.services.codeconnections.model.ResourceSyncStatus;
import software.amazon.awssdk.services.codeconnections.model.Revision;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceSyncAttempt
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceSyncAttempt> {
    private static final SdkField<List<ResourceSyncEvent>> EVENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Events").getter(ResourceSyncAttempt.getter(ResourceSyncAttempt::events)).setter(ResourceSyncAttempt.setter(Builder::events)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Events").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceSyncEvent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Revision> INITIAL_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InitialRevision").getter(ResourceSyncAttempt.getter(ResourceSyncAttempt::initialRevision)).setter(ResourceSyncAttempt.setter(Builder::initialRevision)).constructor(Revision::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialRevision").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartedAt").getter(ResourceSyncAttempt.getter(ResourceSyncAttempt::startedAt)).setter(ResourceSyncAttempt.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartedAt").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ResourceSyncAttempt.getter(ResourceSyncAttempt::statusAsString)).setter(ResourceSyncAttempt.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Revision> TARGET_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetRevision").getter(ResourceSyncAttempt.getter(ResourceSyncAttempt::targetRevision)).setter(ResourceSyncAttempt.setter(Builder::targetRevision)).constructor(Revision::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetRevision").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Target").getter(ResourceSyncAttempt.getter(ResourceSyncAttempt::target)).setter(ResourceSyncAttempt.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENTS_FIELD, INITIAL_REVISION_FIELD, STARTED_AT_FIELD, STATUS_FIELD, TARGET_REVISION_FIELD, TARGET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Events", EVENTS_FIELD);
            this.put("InitialRevision", INITIAL_REVISION_FIELD);
            this.put("StartedAt", STARTED_AT_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("TargetRevision", TARGET_REVISION_FIELD);
            this.put("Target", TARGET_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<ResourceSyncEvent> events;
    private final Revision initialRevision;
    private final Instant startedAt;
    private final String status;
    private final Revision targetRevision;
    private final String target;

    private ResourceSyncAttempt(BuilderImpl builder) {
        this.events = builder.events;
        this.initialRevision = builder.initialRevision;
        this.startedAt = builder.startedAt;
        this.status = builder.status;
        this.targetRevision = builder.targetRevision;
        this.target = builder.target;
    }

    public final boolean hasEvents() {
        return this.events != null && !(this.events instanceof SdkAutoConstructList);
    }

    public final List<ResourceSyncEvent> events() {
        return this.events;
    }

    public final Revision initialRevision() {
        return this.initialRevision;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final ResourceSyncStatus status() {
        return ResourceSyncStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Revision targetRevision() {
        return this.targetRevision;
    }

    public final String target() {
        return this.target;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvents() ? this.events() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.initialRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSyncAttempt)) {
            return false;
        }
        ResourceSyncAttempt other = (ResourceSyncAttempt)obj;
        return this.hasEvents() == other.hasEvents() && Objects.equals(this.events(), other.events()) && Objects.equals(this.initialRevision(), other.initialRevision()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.targetRevision(), other.targetRevision()) && Objects.equals(this.target(), other.target());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceSyncAttempt").add("Events", this.hasEvents() ? this.events() : null).add("InitialRevision", (Object)this.initialRevision()).add("StartedAt", (Object)this.startedAt()).add("Status", (Object)this.statusAsString()).add("TargetRevision", (Object)this.targetRevision()).add("Target", (Object)this.target()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Events": {
                return Optional.ofNullable(clazz.cast(this.events()));
            }
            case "InitialRevision": {
                return Optional.ofNullable(clazz.cast(this.initialRevision()));
            }
            case "StartedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "TargetRevision": {
                return Optional.ofNullable(clazz.cast(this.targetRevision()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourceSyncAttempt, T> g) {
        return obj -> g.apply((ResourceSyncAttempt)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ResourceSyncEvent> events = DefaultSdkAutoConstructList.getInstance();
        private Revision initialRevision;
        private Instant startedAt;
        private String status;
        private Revision targetRevision;
        private String target;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSyncAttempt model) {
            this.events(model.events);
            this.initialRevision(model.initialRevision);
            this.startedAt(model.startedAt);
            this.status(model.status);
            this.targetRevision(model.targetRevision);
            this.target(model.target);
        }

        public final List<ResourceSyncEvent.Builder> getEvents() {
            List<ResourceSyncEvent.Builder> result = ResourceSyncEventListCopier.copyToBuilder(this.events);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvents(Collection<ResourceSyncEvent.BuilderImpl> events) {
            this.events = ResourceSyncEventListCopier.copyFromBuilder(events);
        }

        @Override
        public final Builder events(Collection<ResourceSyncEvent> events) {
            this.events = ResourceSyncEventListCopier.copy(events);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(ResourceSyncEvent ... events) {
            this.events(Arrays.asList(events));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder events(Consumer<ResourceSyncEvent.Builder> ... events) {
            this.events(Stream.of(events).map(c -> (ResourceSyncEvent)((ResourceSyncEvent.Builder)ResourceSyncEvent.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Revision.Builder getInitialRevision() {
            return this.initialRevision != null ? this.initialRevision.toBuilder() : null;
        }

        public final void setInitialRevision(Revision.BuilderImpl initialRevision) {
            this.initialRevision = initialRevision != null ? initialRevision.build() : null;
        }

        @Override
        public final Builder initialRevision(Revision initialRevision) {
            this.initialRevision = initialRevision;
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceSyncStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Revision.Builder getTargetRevision() {
            return this.targetRevision != null ? this.targetRevision.toBuilder() : null;
        }

        public final void setTargetRevision(Revision.BuilderImpl targetRevision) {
            this.targetRevision = targetRevision != null ? targetRevision.build() : null;
        }

        @Override
        public final Builder targetRevision(Revision targetRevision) {
            this.targetRevision = targetRevision;
            return this;
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public ResourceSyncAttempt build() {
            return new ResourceSyncAttempt(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceSyncAttempt> {
        public Builder events(Collection<ResourceSyncEvent> var1);

        public Builder events(ResourceSyncEvent ... var1);

        public Builder events(Consumer<ResourceSyncEvent.Builder> ... var1);

        public Builder initialRevision(Revision var1);

        default public Builder initialRevision(Consumer<Revision.Builder> initialRevision) {
            return this.initialRevision((Revision)((Revision.Builder)Revision.builder().applyMutation(initialRevision)).build());
        }

        public Builder startedAt(Instant var1);

        public Builder status(String var1);

        public Builder status(ResourceSyncStatus var1);

        public Builder targetRevision(Revision var1);

        default public Builder targetRevision(Consumer<Revision.Builder> targetRevision) {
            return this.targetRevision((Revision)((Revision.Builder)Revision.builder().applyMutation(targetRevision)).build());
        }

        public Builder target(String var1);
    }
}

