/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the input of a list repositories operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRepositoriesRequest extends CodeCommitRequest implements
        ToCopyableBuilder<ListRepositoriesRequest.Builder, ListRepositoriesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRepositoriesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("sortBy")
            .getter(getter(ListRepositoriesRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()).build();

    private static final SdkField<String> ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("order")
            .getter(getter(ListRepositoriesRequest::orderAsString)).setter(setter(Builder::order))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("order").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SORT_BY_FIELD, ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final String sortBy;

    private final String order;

    private ListRepositoriesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
        this.order = builder.order;
    }

    /**
     * <p>
     * An enumeration token that allows the operation to batch the results of the operation. Batch sizes are 1,000 for
     * list repository operations. When the client sends the token back to CodeCommit, another page of 1,000 records is
     * retrieved.
     * </p>
     * 
     * @return An enumeration token that allows the operation to batch the results of the operation. Batch sizes are
     *         1,000 for list repository operations. When the client sends the token back to CodeCommit, another page of
     *         1,000 records is retrieved.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The criteria used to sort the results of a list repositories operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortByEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The criteria used to sort the results of a list repositories operation.
     * @see SortByEnum
     */
    public final SortByEnum sortBy() {
        return SortByEnum.fromValue(sortBy);
    }

    /**
     * <p>
     * The criteria used to sort the results of a list repositories operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortByEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortByAsString}.
     * </p>
     * 
     * @return The criteria used to sort the results of a list repositories operation.
     * @see SortByEnum
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The order in which to sort the results of a list repositories operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link OrderEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return The order in which to sort the results of a list repositories operation.
     * @see OrderEnum
     */
    public final OrderEnum order() {
        return OrderEnum.fromValue(order);
    }

    /**
     * <p>
     * The order in which to sort the results of a list repositories operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link OrderEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return The order in which to sort the results of a list repositories operation.
     * @see OrderEnum
     */
    public final String orderAsString() {
        return order;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(orderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRepositoriesRequest)) {
            return false;
        }
        ListRepositoriesRequest other = (ListRepositoriesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(orderAsString(), other.orderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRepositoriesRequest").add("NextToken", nextToken()).add("SortBy", sortByAsString())
                .add("Order", orderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "sortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "order":
            return Optional.ofNullable(clazz.cast(orderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        map.put("order", ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRepositoriesRequest, T> g) {
        return obj -> g.apply((ListRepositoriesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends CodeCommitRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListRepositoriesRequest> {
        /**
         * <p>
         * An enumeration token that allows the operation to batch the results of the operation. Batch sizes are 1,000
         * for list repository operations. When the client sends the token back to CodeCommit, another page of 1,000
         * records is retrieved.
         * </p>
         * 
         * @param nextToken
         *        An enumeration token that allows the operation to batch the results of the operation. Batch sizes are
         *        1,000 for list repository operations. When the client sends the token back to CodeCommit, another page
         *        of 1,000 records is retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The criteria used to sort the results of a list repositories operation.
         * </p>
         * 
         * @param sortBy
         *        The criteria used to sort the results of a list repositories operation.
         * @see SortByEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortByEnum
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The criteria used to sort the results of a list repositories operation.
         * </p>
         * 
         * @param sortBy
         *        The criteria used to sort the results of a list repositories operation.
         * @see SortByEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortByEnum
         */
        Builder sortBy(SortByEnum sortBy);

        /**
         * <p>
         * The order in which to sort the results of a list repositories operation.
         * </p>
         * 
         * @param order
         *        The order in which to sort the results of a list repositories operation.
         * @see OrderEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderEnum
         */
        Builder order(String order);

        /**
         * <p>
         * The order in which to sort the results of a list repositories operation.
         * </p>
         * 
         * @param order
         *        The order in which to sort the results of a list repositories operation.
         * @see OrderEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OrderEnum
         */
        Builder order(OrderEnum order);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String nextToken;

        private String sortBy;

        private String order;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRepositoriesRequest model) {
            super(model);
            nextToken(model.nextToken);
            sortBy(model.sortBy);
            order(model.order);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortByEnum sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getOrder() {
            return order;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(OrderEnum order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRepositoriesRequest build() {
            return new ListRepositoriesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
