/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitRequest;
import software.amazon.awssdk.services.codecommit.model.OverrideStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OverridePullRequestApprovalRulesRequest
extends CodeCommitRequest
implements ToCopyableBuilder<Builder, OverridePullRequestApprovalRulesRequest> {
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pullRequestId").getter(OverridePullRequestApprovalRulesRequest.getter(OverridePullRequestApprovalRulesRequest::pullRequestId)).setter(OverridePullRequestApprovalRulesRequest.setter(Builder::pullRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()}).build();
    private static final SdkField<String> REVISION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revisionId").getter(OverridePullRequestApprovalRulesRequest.getter(OverridePullRequestApprovalRulesRequest::revisionId)).setter(OverridePullRequestApprovalRulesRequest.setter(Builder::revisionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionId").build()}).build();
    private static final SdkField<String> OVERRIDE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("overrideStatus").getter(OverridePullRequestApprovalRulesRequest.getter(OverridePullRequestApprovalRulesRequest::overrideStatusAsString)).setter(OverridePullRequestApprovalRulesRequest.setter(Builder::overrideStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_REQUEST_ID_FIELD, REVISION_ID_FIELD, OVERRIDE_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OverridePullRequestApprovalRulesRequest.memberNameToFieldInitializer();
    private final String pullRequestId;
    private final String revisionId;
    private final String overrideStatus;

    private OverridePullRequestApprovalRulesRequest(BuilderImpl builder) {
        super(builder);
        this.pullRequestId = builder.pullRequestId;
        this.revisionId = builder.revisionId;
        this.overrideStatus = builder.overrideStatus;
    }

    public final String pullRequestId() {
        return this.pullRequestId;
    }

    public final String revisionId() {
        return this.revisionId;
    }

    public final OverrideStatus overrideStatus() {
        return OverrideStatus.fromValue(this.overrideStatus);
    }

    public final String overrideStatusAsString() {
        return this.overrideStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.revisionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OverridePullRequestApprovalRulesRequest)) {
            return false;
        }
        OverridePullRequestApprovalRulesRequest other = (OverridePullRequestApprovalRulesRequest)((Object)obj);
        return Objects.equals(this.pullRequestId(), other.pullRequestId()) && Objects.equals(this.revisionId(), other.revisionId()) && Objects.equals(this.overrideStatusAsString(), other.overrideStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"OverridePullRequestApprovalRulesRequest").add("PullRequestId", (Object)this.pullRequestId()).add("RevisionId", (Object)this.revisionId()).add("OverrideStatus", (Object)this.overrideStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pullRequestId": {
                return Optional.ofNullable(clazz.cast(this.pullRequestId()));
            }
            case "revisionId": {
                return Optional.ofNullable(clazz.cast(this.revisionId()));
            }
            case "overrideStatus": {
                return Optional.ofNullable(clazz.cast(this.overrideStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("pullRequestId", PULL_REQUEST_ID_FIELD);
        map.put("revisionId", REVISION_ID_FIELD);
        map.put("overrideStatus", OVERRIDE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OverridePullRequestApprovalRulesRequest, T> g) {
        return obj -> g.apply((OverridePullRequestApprovalRulesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitRequest.BuilderImpl
    implements Builder {
        private String pullRequestId;
        private String revisionId;
        private String overrideStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(OverridePullRequestApprovalRulesRequest model) {
            super(model);
            this.pullRequestId(model.pullRequestId);
            this.revisionId(model.revisionId);
            this.overrideStatus(model.overrideStatus);
        }

        public final String getPullRequestId() {
            return this.pullRequestId;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final String getRevisionId() {
            return this.revisionId;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final String getOverrideStatus() {
            return this.overrideStatus;
        }

        public final void setOverrideStatus(String overrideStatus) {
            this.overrideStatus = overrideStatus;
        }

        @Override
        public final Builder overrideStatus(String overrideStatus) {
            this.overrideStatus = overrideStatus;
            return this;
        }

        @Override
        public final Builder overrideStatus(OverrideStatus overrideStatus) {
            this.overrideStatus(overrideStatus == null ? null : overrideStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public OverridePullRequestApprovalRulesRequest build() {
            return new OverridePullRequestApprovalRulesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CodeCommitRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, OverridePullRequestApprovalRulesRequest> {
        public Builder pullRequestId(String var1);

        public Builder revisionId(String var1);

        public Builder overrideStatus(String var1);

        public Builder overrideStatus(OverrideStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

