/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.Comment;
import software.amazon.awssdk.services.codecommit.model.Location;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PostCommentForPullRequestResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, PostCommentForPullRequestResponse> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(PostCommentForPullRequestResponse.getter(PostCommentForPullRequestResponse::repositoryName)).setter(PostCommentForPullRequestResponse.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> PULL_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pullRequestId").getter(PostCommentForPullRequestResponse.getter(PostCommentForPullRequestResponse::pullRequestId)).setter(PostCommentForPullRequestResponse.setter(Builder::pullRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullRequestId").build()}).build();
    private static final SdkField<String> BEFORE_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("beforeCommitId").getter(PostCommentForPullRequestResponse.getter(PostCommentForPullRequestResponse::beforeCommitId)).setter(PostCommentForPullRequestResponse.setter(Builder::beforeCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeCommitId").build()}).build();
    private static final SdkField<String> AFTER_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterCommitId").getter(PostCommentForPullRequestResponse.getter(PostCommentForPullRequestResponse::afterCommitId)).setter(PostCommentForPullRequestResponse.setter(Builder::afterCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterCommitId").build()}).build();
    private static final SdkField<String> BEFORE_BLOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("beforeBlobId").getter(PostCommentForPullRequestResponse.getter(PostCommentForPullRequestResponse::beforeBlobId)).setter(PostCommentForPullRequestResponse.setter(Builder::beforeBlobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeBlobId").build()}).build();
    private static final SdkField<String> AFTER_BLOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("afterBlobId").getter(PostCommentForPullRequestResponse.getter(PostCommentForPullRequestResponse::afterBlobId)).setter(PostCommentForPullRequestResponse.setter(Builder::afterBlobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterBlobId").build()}).build();
    private static final SdkField<Location> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("location").getter(PostCommentForPullRequestResponse.getter(PostCommentForPullRequestResponse::location)).setter(PostCommentForPullRequestResponse.setter(Builder::location)).constructor(Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<Comment> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("comment").getter(PostCommentForPullRequestResponse.getter(PostCommentForPullRequestResponse::comment)).setter(PostCommentForPullRequestResponse.setter(Builder::comment)).constructor(Comment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, PULL_REQUEST_ID_FIELD, BEFORE_COMMIT_ID_FIELD, AFTER_COMMIT_ID_FIELD, BEFORE_BLOB_ID_FIELD, AFTER_BLOB_ID_FIELD, LOCATION_FIELD, COMMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("repositoryName", REPOSITORY_NAME_FIELD);
            this.put("pullRequestId", PULL_REQUEST_ID_FIELD);
            this.put("beforeCommitId", BEFORE_COMMIT_ID_FIELD);
            this.put("afterCommitId", AFTER_COMMIT_ID_FIELD);
            this.put("beforeBlobId", BEFORE_BLOB_ID_FIELD);
            this.put("afterBlobId", AFTER_BLOB_ID_FIELD);
            this.put("location", LOCATION_FIELD);
            this.put("comment", COMMENT_FIELD);
        }
    });
    private final String repositoryName;
    private final String pullRequestId;
    private final String beforeCommitId;
    private final String afterCommitId;
    private final String beforeBlobId;
    private final String afterBlobId;
    private final Location location;
    private final Comment comment;

    private PostCommentForPullRequestResponse(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.pullRequestId = builder.pullRequestId;
        this.beforeCommitId = builder.beforeCommitId;
        this.afterCommitId = builder.afterCommitId;
        this.beforeBlobId = builder.beforeBlobId;
        this.afterBlobId = builder.afterBlobId;
        this.location = builder.location;
        this.comment = builder.comment;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String pullRequestId() {
        return this.pullRequestId;
    }

    public final String beforeCommitId() {
        return this.beforeCommitId;
    }

    public final String afterCommitId() {
        return this.afterCommitId;
    }

    public final String beforeBlobId() {
        return this.beforeBlobId;
    }

    public final String afterBlobId() {
        return this.afterBlobId;
    }

    public final Location location() {
        return this.location;
    }

    public final Comment comment() {
        return this.comment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.pullRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.beforeCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.beforeBlobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.afterBlobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostCommentForPullRequestResponse)) {
            return false;
        }
        PostCommentForPullRequestResponse other = (PostCommentForPullRequestResponse)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.pullRequestId(), other.pullRequestId()) && Objects.equals(this.beforeCommitId(), other.beforeCommitId()) && Objects.equals(this.afterCommitId(), other.afterCommitId()) && Objects.equals(this.beforeBlobId(), other.beforeBlobId()) && Objects.equals(this.afterBlobId(), other.afterBlobId()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.comment(), other.comment());
    }

    public final String toString() {
        return ToString.builder((String)"PostCommentForPullRequestResponse").add("RepositoryName", (Object)this.repositoryName()).add("PullRequestId", (Object)this.pullRequestId()).add("BeforeCommitId", (Object)this.beforeCommitId()).add("AfterCommitId", (Object)this.afterCommitId()).add("BeforeBlobId", (Object)this.beforeBlobId()).add("AfterBlobId", (Object)this.afterBlobId()).add("Location", (Object)this.location()).add("Comment", (Object)this.comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "pullRequestId": {
                return Optional.ofNullable(clazz.cast(this.pullRequestId()));
            }
            case "beforeCommitId": {
                return Optional.ofNullable(clazz.cast(this.beforeCommitId()));
            }
            case "afterCommitId": {
                return Optional.ofNullable(clazz.cast(this.afterCommitId()));
            }
            case "beforeBlobId": {
                return Optional.ofNullable(clazz.cast(this.beforeBlobId()));
            }
            case "afterBlobId": {
                return Optional.ofNullable(clazz.cast(this.afterBlobId()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PostCommentForPullRequestResponse, T> g) {
        return obj -> g.apply((PostCommentForPullRequestResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private String repositoryName;
        private String pullRequestId;
        private String beforeCommitId;
        private String afterCommitId;
        private String beforeBlobId;
        private String afterBlobId;
        private Location location;
        private Comment comment;

        private BuilderImpl() {
        }

        private BuilderImpl(PostCommentForPullRequestResponse model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.pullRequestId(model.pullRequestId);
            this.beforeCommitId(model.beforeCommitId);
            this.afterCommitId(model.afterCommitId);
            this.beforeBlobId(model.beforeBlobId);
            this.afterBlobId(model.afterBlobId);
            this.location(model.location);
            this.comment(model.comment);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getPullRequestId() {
            return this.pullRequestId;
        }

        public final void setPullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
        }

        @Override
        public final Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public final String getBeforeCommitId() {
            return this.beforeCommitId;
        }

        public final void setBeforeCommitId(String beforeCommitId) {
            this.beforeCommitId = beforeCommitId;
        }

        @Override
        public final Builder beforeCommitId(String beforeCommitId) {
            this.beforeCommitId = beforeCommitId;
            return this;
        }

        public final String getAfterCommitId() {
            return this.afterCommitId;
        }

        public final void setAfterCommitId(String afterCommitId) {
            this.afterCommitId = afterCommitId;
        }

        @Override
        public final Builder afterCommitId(String afterCommitId) {
            this.afterCommitId = afterCommitId;
            return this;
        }

        public final String getBeforeBlobId() {
            return this.beforeBlobId;
        }

        public final void setBeforeBlobId(String beforeBlobId) {
            this.beforeBlobId = beforeBlobId;
        }

        @Override
        public final Builder beforeBlobId(String beforeBlobId) {
            this.beforeBlobId = beforeBlobId;
            return this;
        }

        public final String getAfterBlobId() {
            return this.afterBlobId;
        }

        public final void setAfterBlobId(String afterBlobId) {
            this.afterBlobId = afterBlobId;
        }

        @Override
        public final Builder afterBlobId(String afterBlobId) {
            this.afterBlobId = afterBlobId;
            return this;
        }

        public final Location.Builder getLocation() {
            return this.location != null ? this.location.toBuilder() : null;
        }

        public final void setLocation(Location.BuilderImpl location) {
            this.location = location != null ? location.build() : null;
        }

        @Override
        public final Builder location(Location location) {
            this.location = location;
            return this;
        }

        public final Comment.Builder getComment() {
            return this.comment != null ? this.comment.toBuilder() : null;
        }

        public final void setComment(Comment.BuilderImpl comment) {
            this.comment = comment != null ? comment.build() : null;
        }

        @Override
        public final Builder comment(Comment comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public PostCommentForPullRequestResponse build() {
            return new PostCommentForPullRequestResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PostCommentForPullRequestResponse> {
        public Builder repositoryName(String var1);

        public Builder pullRequestId(String var1);

        public Builder beforeCommitId(String var1);

        public Builder afterCommitId(String var1);

        public Builder beforeBlobId(String var1);

        public Builder afterBlobId(String var1);

        public Builder location(Location var1);

        default public Builder location(Consumer<Location.Builder> location) {
            return this.location((Location)((Location.Builder)Location.builder().applyMutation(location)).build());
        }

        public Builder comment(Comment var1);

        default public Builder comment(Consumer<Comment.Builder> comment) {
            return this.comment((Comment)((Comment.Builder)Comment.builder().applyMutation(comment)).build());
        }
    }
}

