/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.Commit;
import software.amazon.awssdk.services.codecommit.model.RevisionChildrenCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FileVersion
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FileVersion> {
    private static final SdkField<Commit> COMMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("commit").getter(FileVersion.getter(FileVersion::commit)).setter(FileVersion.setter(Builder::commit)).constructor(Commit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commit").build()}).build();
    private static final SdkField<String> BLOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blobId").getter(FileVersion.getter(FileVersion::blobId)).setter(FileVersion.setter(Builder::blobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blobId").build()}).build();
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("path").getter(FileVersion.getter(FileVersion::path)).setter(FileVersion.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build()}).build();
    private static final SdkField<List<String>> REVISION_CHILDREN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("revisionChildren").getter(FileVersion.getter(FileVersion::revisionChildren)).setter(FileVersion.setter(Builder::revisionChildren)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionChildren").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_FIELD, BLOB_ID_FIELD, PATH_FIELD, REVISION_CHILDREN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("commit", COMMIT_FIELD);
            this.put("blobId", BLOB_ID_FIELD);
            this.put("path", PATH_FIELD);
            this.put("revisionChildren", REVISION_CHILDREN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Commit commit;
    private final String blobId;
    private final String path;
    private final List<String> revisionChildren;

    private FileVersion(BuilderImpl builder) {
        this.commit = builder.commit;
        this.blobId = builder.blobId;
        this.path = builder.path;
        this.revisionChildren = builder.revisionChildren;
    }

    public final Commit commit() {
        return this.commit;
    }

    public final String blobId() {
        return this.blobId;
    }

    public final String path() {
        return this.path;
    }

    public final boolean hasRevisionChildren() {
        return this.revisionChildren != null && !(this.revisionChildren instanceof SdkAutoConstructList);
    }

    public final List<String> revisionChildren() {
        return this.revisionChildren;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commit());
        hashCode = 31 * hashCode + Objects.hashCode(this.blobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRevisionChildren() ? this.revisionChildren() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileVersion)) {
            return false;
        }
        FileVersion other = (FileVersion)obj;
        return Objects.equals(this.commit(), other.commit()) && Objects.equals(this.blobId(), other.blobId()) && Objects.equals(this.path(), other.path()) && this.hasRevisionChildren() == other.hasRevisionChildren() && Objects.equals(this.revisionChildren(), other.revisionChildren());
    }

    public final String toString() {
        return ToString.builder((String)"FileVersion").add("Commit", (Object)this.commit()).add("BlobId", (Object)this.blobId()).add("Path", (Object)this.path()).add("RevisionChildren", this.hasRevisionChildren() ? this.revisionChildren() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commit": {
                return Optional.ofNullable(clazz.cast(this.commit()));
            }
            case "blobId": {
                return Optional.ofNullable(clazz.cast(this.blobId()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "revisionChildren": {
                return Optional.ofNullable(clazz.cast(this.revisionChildren()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<FileVersion, T> g) {
        return obj -> g.apply((FileVersion)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Commit commit;
        private String blobId;
        private String path;
        private List<String> revisionChildren = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FileVersion model) {
            this.commit(model.commit);
            this.blobId(model.blobId);
            this.path(model.path);
            this.revisionChildren(model.revisionChildren);
        }

        public final Commit.Builder getCommit() {
            return this.commit != null ? this.commit.toBuilder() : null;
        }

        public final void setCommit(Commit.BuilderImpl commit) {
            this.commit = commit != null ? commit.build() : null;
        }

        @Override
        public final Builder commit(Commit commit) {
            this.commit = commit;
            return this;
        }

        public final String getBlobId() {
            return this.blobId;
        }

        public final void setBlobId(String blobId) {
            this.blobId = blobId;
        }

        @Override
        public final Builder blobId(String blobId) {
            this.blobId = blobId;
            return this;
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Collection<String> getRevisionChildren() {
            if (this.revisionChildren instanceof SdkAutoConstructList) {
                return null;
            }
            return this.revisionChildren;
        }

        public final void setRevisionChildren(Collection<String> revisionChildren) {
            this.revisionChildren = RevisionChildrenCopier.copy(revisionChildren);
        }

        @Override
        public final Builder revisionChildren(Collection<String> revisionChildren) {
            this.revisionChildren = RevisionChildrenCopier.copy(revisionChildren);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder revisionChildren(String ... revisionChildren) {
            this.revisionChildren(Arrays.asList(revisionChildren));
            return this;
        }

        public FileVersion build() {
            return new FileVersion(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FileVersion> {
        public Builder commit(Commit var1);

        default public Builder commit(Consumer<Commit.Builder> commit) {
            return this.commit((Commit)((Commit.Builder)Commit.builder().applyMutation(commit)).build());
        }

        public Builder blobId(String var1);

        public Builder path(String var1);

        public Builder revisionChildren(Collection<String> var1);

        public Builder revisionChildren(String ... var1);
    }
}

