/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.services.codecommit.model.ConflictMetadata;
import software.amazon.awssdk.services.codecommit.model.MergeHunk;
import software.amazon.awssdk.services.codecommit.model.MergeHunksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMergeConflictsResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, DescribeMergeConflictsResponse> {
    private static final SdkField<ConflictMetadata> CONFLICT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("conflictMetadata").getter(DescribeMergeConflictsResponse.getter(DescribeMergeConflictsResponse::conflictMetadata)).setter(DescribeMergeConflictsResponse.setter(Builder::conflictMetadata)).constructor(ConflictMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conflictMetadata").build()}).build();
    private static final SdkField<List<MergeHunk>> MERGE_HUNKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("mergeHunks").getter(DescribeMergeConflictsResponse.getter(DescribeMergeConflictsResponse::mergeHunks)).setter(DescribeMergeConflictsResponse.setter(Builder::mergeHunks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeHunks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MergeHunk::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeMergeConflictsResponse.getter(DescribeMergeConflictsResponse::nextToken)).setter(DescribeMergeConflictsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> DESTINATION_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationCommitId").getter(DescribeMergeConflictsResponse.getter(DescribeMergeConflictsResponse::destinationCommitId)).setter(DescribeMergeConflictsResponse.setter(Builder::destinationCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationCommitId").build()}).build();
    private static final SdkField<String> SOURCE_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceCommitId").getter(DescribeMergeConflictsResponse.getter(DescribeMergeConflictsResponse::sourceCommitId)).setter(DescribeMergeConflictsResponse.setter(Builder::sourceCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCommitId").build()}).build();
    private static final SdkField<String> BASE_COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baseCommitId").getter(DescribeMergeConflictsResponse.getter(DescribeMergeConflictsResponse::baseCommitId)).setter(DescribeMergeConflictsResponse.setter(Builder::baseCommitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseCommitId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFLICT_METADATA_FIELD, MERGE_HUNKS_FIELD, NEXT_TOKEN_FIELD, DESTINATION_COMMIT_ID_FIELD, SOURCE_COMMIT_ID_FIELD, BASE_COMMIT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("conflictMetadata", CONFLICT_METADATA_FIELD);
            this.put("mergeHunks", MERGE_HUNKS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("destinationCommitId", DESTINATION_COMMIT_ID_FIELD);
            this.put("sourceCommitId", SOURCE_COMMIT_ID_FIELD);
            this.put("baseCommitId", BASE_COMMIT_ID_FIELD);
        }
    });
    private final ConflictMetadata conflictMetadata;
    private final List<MergeHunk> mergeHunks;
    private final String nextToken;
    private final String destinationCommitId;
    private final String sourceCommitId;
    private final String baseCommitId;

    private DescribeMergeConflictsResponse(BuilderImpl builder) {
        super(builder);
        this.conflictMetadata = builder.conflictMetadata;
        this.mergeHunks = builder.mergeHunks;
        this.nextToken = builder.nextToken;
        this.destinationCommitId = builder.destinationCommitId;
        this.sourceCommitId = builder.sourceCommitId;
        this.baseCommitId = builder.baseCommitId;
    }

    public final ConflictMetadata conflictMetadata() {
        return this.conflictMetadata;
    }

    public final boolean hasMergeHunks() {
        return this.mergeHunks != null && !(this.mergeHunks instanceof SdkAutoConstructList);
    }

    public final List<MergeHunk> mergeHunks() {
        return this.mergeHunks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String destinationCommitId() {
        return this.destinationCommitId;
    }

    public final String sourceCommitId() {
        return this.sourceCommitId;
    }

    public final String baseCommitId() {
        return this.baseCommitId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.conflictMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMergeHunks() ? this.mergeHunks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceCommitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.baseCommitId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMergeConflictsResponse)) {
            return false;
        }
        DescribeMergeConflictsResponse other = (DescribeMergeConflictsResponse)((Object)obj);
        return Objects.equals(this.conflictMetadata(), other.conflictMetadata()) && this.hasMergeHunks() == other.hasMergeHunks() && Objects.equals(this.mergeHunks(), other.mergeHunks()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.destinationCommitId(), other.destinationCommitId()) && Objects.equals(this.sourceCommitId(), other.sourceCommitId()) && Objects.equals(this.baseCommitId(), other.baseCommitId());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMergeConflictsResponse").add("ConflictMetadata", (Object)this.conflictMetadata()).add("MergeHunks", this.hasMergeHunks() ? this.mergeHunks() : null).add("NextToken", (Object)this.nextToken()).add("DestinationCommitId", (Object)this.destinationCommitId()).add("SourceCommitId", (Object)this.sourceCommitId()).add("BaseCommitId", (Object)this.baseCommitId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "conflictMetadata": {
                return Optional.ofNullable(clazz.cast(this.conflictMetadata()));
            }
            case "mergeHunks": {
                return Optional.ofNullable(clazz.cast(this.mergeHunks()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "destinationCommitId": {
                return Optional.ofNullable(clazz.cast(this.destinationCommitId()));
            }
            case "sourceCommitId": {
                return Optional.ofNullable(clazz.cast(this.sourceCommitId()));
            }
            case "baseCommitId": {
                return Optional.ofNullable(clazz.cast(this.baseCommitId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMergeConflictsResponse, T> g) {
        return obj -> g.apply((DescribeMergeConflictsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private ConflictMetadata conflictMetadata;
        private List<MergeHunk> mergeHunks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String destinationCommitId;
        private String sourceCommitId;
        private String baseCommitId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMergeConflictsResponse model) {
            super(model);
            this.conflictMetadata(model.conflictMetadata);
            this.mergeHunks(model.mergeHunks);
            this.nextToken(model.nextToken);
            this.destinationCommitId(model.destinationCommitId);
            this.sourceCommitId(model.sourceCommitId);
            this.baseCommitId(model.baseCommitId);
        }

        public final ConflictMetadata.Builder getConflictMetadata() {
            return this.conflictMetadata != null ? this.conflictMetadata.toBuilder() : null;
        }

        public final void setConflictMetadata(ConflictMetadata.BuilderImpl conflictMetadata) {
            this.conflictMetadata = conflictMetadata != null ? conflictMetadata.build() : null;
        }

        @Override
        public final Builder conflictMetadata(ConflictMetadata conflictMetadata) {
            this.conflictMetadata = conflictMetadata;
            return this;
        }

        public final List<MergeHunk.Builder> getMergeHunks() {
            List<MergeHunk.Builder> result = MergeHunksCopier.copyToBuilder(this.mergeHunks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMergeHunks(Collection<MergeHunk.BuilderImpl> mergeHunks) {
            this.mergeHunks = MergeHunksCopier.copyFromBuilder(mergeHunks);
        }

        @Override
        public final Builder mergeHunks(Collection<MergeHunk> mergeHunks) {
            this.mergeHunks = MergeHunksCopier.copy(mergeHunks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mergeHunks(MergeHunk ... mergeHunks) {
            this.mergeHunks(Arrays.asList(mergeHunks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mergeHunks(Consumer<MergeHunk.Builder> ... mergeHunks) {
            this.mergeHunks(Stream.of(mergeHunks).map(c -> (MergeHunk)((MergeHunk.Builder)MergeHunk.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getDestinationCommitId() {
            return this.destinationCommitId;
        }

        public final void setDestinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
        }

        @Override
        public final Builder destinationCommitId(String destinationCommitId) {
            this.destinationCommitId = destinationCommitId;
            return this;
        }

        public final String getSourceCommitId() {
            return this.sourceCommitId;
        }

        public final void setSourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
        }

        @Override
        public final Builder sourceCommitId(String sourceCommitId) {
            this.sourceCommitId = sourceCommitId;
            return this;
        }

        public final String getBaseCommitId() {
            return this.baseCommitId;
        }

        public final void setBaseCommitId(String baseCommitId) {
            this.baseCommitId = baseCommitId;
        }

        @Override
        public final Builder baseCommitId(String baseCommitId) {
            this.baseCommitId = baseCommitId;
            return this;
        }

        @Override
        public DescribeMergeConflictsResponse build() {
            return new DescribeMergeConflictsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMergeConflictsResponse> {
        public Builder conflictMetadata(ConflictMetadata var1);

        default public Builder conflictMetadata(Consumer<ConflictMetadata.Builder> conflictMetadata) {
            return this.conflictMetadata((ConflictMetadata)((ConflictMetadata.Builder)ConflictMetadata.builder().applyMutation(conflictMetadata)).build());
        }

        public Builder mergeHunks(Collection<MergeHunk> var1);

        public Builder mergeHunks(MergeHunk ... var1);

        public Builder mergeHunks(Consumer<MergeHunk.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder destinationCommitId(String var1);

        public Builder sourceCommitId(String var1);

        public Builder baseCommitId(String var1);
    }
}

