/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteFileResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, DeleteFileResponse> {
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commitId").getter(DeleteFileResponse.getter(DeleteFileResponse::commitId)).setter(DeleteFileResponse.setter(Builder::commitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()}).build();
    private static final SdkField<String> BLOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("blobId").getter(DeleteFileResponse.getter(DeleteFileResponse::blobId)).setter(DeleteFileResponse.setter(Builder::blobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blobId").build()}).build();
    private static final SdkField<String> TREE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("treeId").getter(DeleteFileResponse.getter(DeleteFileResponse::treeId)).setter(DeleteFileResponse.setter(Builder::treeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treeId").build()}).build();
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filePath").getter(DeleteFileResponse.getter(DeleteFileResponse::filePath)).setter(DeleteFileResponse.setter(Builder::filePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_ID_FIELD, BLOB_ID_FIELD, TREE_ID_FIELD, FILE_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("commitId", COMMIT_ID_FIELD);
            this.put("blobId", BLOB_ID_FIELD);
            this.put("treeId", TREE_ID_FIELD);
            this.put("filePath", FILE_PATH_FIELD);
        }
    });
    private final String commitId;
    private final String blobId;
    private final String treeId;
    private final String filePath;

    private DeleteFileResponse(BuilderImpl builder) {
        super(builder);
        this.commitId = builder.commitId;
        this.blobId = builder.blobId;
        this.treeId = builder.treeId;
        this.filePath = builder.filePath;
    }

    public final String commitId() {
        return this.commitId;
    }

    public final String blobId() {
        return this.blobId;
    }

    public final String treeId() {
        return this.treeId;
    }

    public final String filePath() {
        return this.filePath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.commitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.blobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.treeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteFileResponse)) {
            return false;
        }
        DeleteFileResponse other = (DeleteFileResponse)((Object)obj);
        return Objects.equals(this.commitId(), other.commitId()) && Objects.equals(this.blobId(), other.blobId()) && Objects.equals(this.treeId(), other.treeId()) && Objects.equals(this.filePath(), other.filePath());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteFileResponse").add("CommitId", (Object)this.commitId()).add("BlobId", (Object)this.blobId()).add("TreeId", (Object)this.treeId()).add("FilePath", (Object)this.filePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commitId": {
                return Optional.ofNullable(clazz.cast(this.commitId()));
            }
            case "blobId": {
                return Optional.ofNullable(clazz.cast(this.blobId()));
            }
            case "treeId": {
                return Optional.ofNullable(clazz.cast(this.treeId()));
            }
            case "filePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteFileResponse, T> g) {
        return obj -> g.apply((DeleteFileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private String commitId;
        private String blobId;
        private String treeId;
        private String filePath;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteFileResponse model) {
            super(model);
            this.commitId(model.commitId);
            this.blobId(model.blobId);
            this.treeId(model.treeId);
            this.filePath(model.filePath);
        }

        public final String getCommitId() {
            return this.commitId;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final String getBlobId() {
            return this.blobId;
        }

        public final void setBlobId(String blobId) {
            this.blobId = blobId;
        }

        @Override
        public final Builder blobId(String blobId) {
            this.blobId = blobId;
            return this;
        }

        public final String getTreeId() {
            return this.treeId;
        }

        public final void setTreeId(String treeId) {
            this.treeId = treeId;
        }

        @Override
        public final Builder treeId(String treeId) {
            this.treeId = treeId;
            return this;
        }

        public final String getFilePath() {
            return this.filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        @Override
        public DeleteFileResponse build() {
            return new DeleteFileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteFileResponse> {
        public Builder commitId(String var1);

        public Builder blobId(String var1);

        public Builder treeId(String var1);

        public Builder filePath(String var1);
    }
}

