/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codecommit.model.FileModes;
import software.amazon.awssdk.services.codecommit.model.FileSizes;
import software.amazon.awssdk.services.codecommit.model.IsBinaryFile;
import software.amazon.awssdk.services.codecommit.model.MergeOperations;
import software.amazon.awssdk.services.codecommit.model.ObjectTypes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConflictMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConflictMetadata> {
    private static final SdkField<String> FILE_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filePath").getter(ConflictMetadata.getter(ConflictMetadata::filePath)).setter(ConflictMetadata.setter(Builder::filePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filePath").build()}).build();
    private static final SdkField<FileSizes> FILE_SIZES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fileSizes").getter(ConflictMetadata.getter(ConflictMetadata::fileSizes)).setter(ConflictMetadata.setter(Builder::fileSizes)).constructor(FileSizes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSizes").build()}).build();
    private static final SdkField<FileModes> FILE_MODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fileModes").getter(ConflictMetadata.getter(ConflictMetadata::fileModes)).setter(ConflictMetadata.setter(Builder::fileModes)).constructor(FileModes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileModes").build()}).build();
    private static final SdkField<ObjectTypes> OBJECT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("objectTypes").getter(ConflictMetadata.getter(ConflictMetadata::objectTypes)).setter(ConflictMetadata.setter(Builder::objectTypes)).constructor(ObjectTypes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectTypes").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_CONFLICTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfConflicts").getter(ConflictMetadata.getter(ConflictMetadata::numberOfConflicts)).setter(ConflictMetadata.setter(Builder::numberOfConflicts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfConflicts").build()}).build();
    private static final SdkField<IsBinaryFile> IS_BINARY_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("isBinaryFile").getter(ConflictMetadata.getter(ConflictMetadata::isBinaryFile)).setter(ConflictMetadata.setter(Builder::isBinaryFile)).constructor(IsBinaryFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isBinaryFile").build()}).build();
    private static final SdkField<Boolean> CONTENT_CONFLICT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("contentConflict").getter(ConflictMetadata.getter(ConflictMetadata::contentConflict)).setter(ConflictMetadata.setter(Builder::contentConflict)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentConflict").build()}).build();
    private static final SdkField<Boolean> FILE_MODE_CONFLICT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("fileModeConflict").getter(ConflictMetadata.getter(ConflictMetadata::fileModeConflict)).setter(ConflictMetadata.setter(Builder::fileModeConflict)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileModeConflict").build()}).build();
    private static final SdkField<Boolean> OBJECT_TYPE_CONFLICT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("objectTypeConflict").getter(ConflictMetadata.getter(ConflictMetadata::objectTypeConflict)).setter(ConflictMetadata.setter(Builder::objectTypeConflict)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectTypeConflict").build()}).build();
    private static final SdkField<MergeOperations> MERGE_OPERATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("mergeOperations").getter(ConflictMetadata.getter(ConflictMetadata::mergeOperations)).setter(ConflictMetadata.setter(Builder::mergeOperations)).constructor(MergeOperations::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergeOperations").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_PATH_FIELD, FILE_SIZES_FIELD, FILE_MODES_FIELD, OBJECT_TYPES_FIELD, NUMBER_OF_CONFLICTS_FIELD, IS_BINARY_FILE_FIELD, CONTENT_CONFLICT_FIELD, FILE_MODE_CONFLICT_FIELD, OBJECT_TYPE_CONFLICT_FIELD, MERGE_OPERATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("filePath", FILE_PATH_FIELD);
            this.put("fileSizes", FILE_SIZES_FIELD);
            this.put("fileModes", FILE_MODES_FIELD);
            this.put("objectTypes", OBJECT_TYPES_FIELD);
            this.put("numberOfConflicts", NUMBER_OF_CONFLICTS_FIELD);
            this.put("isBinaryFile", IS_BINARY_FILE_FIELD);
            this.put("contentConflict", CONTENT_CONFLICT_FIELD);
            this.put("fileModeConflict", FILE_MODE_CONFLICT_FIELD);
            this.put("objectTypeConflict", OBJECT_TYPE_CONFLICT_FIELD);
            this.put("mergeOperations", MERGE_OPERATIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String filePath;
    private final FileSizes fileSizes;
    private final FileModes fileModes;
    private final ObjectTypes objectTypes;
    private final Integer numberOfConflicts;
    private final IsBinaryFile isBinaryFile;
    private final Boolean contentConflict;
    private final Boolean fileModeConflict;
    private final Boolean objectTypeConflict;
    private final MergeOperations mergeOperations;

    private ConflictMetadata(BuilderImpl builder) {
        this.filePath = builder.filePath;
        this.fileSizes = builder.fileSizes;
        this.fileModes = builder.fileModes;
        this.objectTypes = builder.objectTypes;
        this.numberOfConflicts = builder.numberOfConflicts;
        this.isBinaryFile = builder.isBinaryFile;
        this.contentConflict = builder.contentConflict;
        this.fileModeConflict = builder.fileModeConflict;
        this.objectTypeConflict = builder.objectTypeConflict;
        this.mergeOperations = builder.mergeOperations;
    }

    public final String filePath() {
        return this.filePath;
    }

    public final FileSizes fileSizes() {
        return this.fileSizes;
    }

    public final FileModes fileModes() {
        return this.fileModes;
    }

    public final ObjectTypes objectTypes() {
        return this.objectTypes;
    }

    public final Integer numberOfConflicts() {
        return this.numberOfConflicts;
    }

    public final IsBinaryFile isBinaryFile() {
        return this.isBinaryFile;
    }

    public final Boolean contentConflict() {
        return this.contentConflict;
    }

    public final Boolean fileModeConflict() {
        return this.fileModeConflict;
    }

    public final Boolean objectTypeConflict() {
        return this.objectTypeConflict;
    }

    public final MergeOperations mergeOperations() {
        return this.mergeOperations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filePath());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileSizes());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileModes());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypes());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfConflicts());
        hashCode = 31 * hashCode + Objects.hashCode(this.isBinaryFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.contentConflict());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileModeConflict());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypeConflict());
        hashCode = 31 * hashCode + Objects.hashCode(this.mergeOperations());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConflictMetadata)) {
            return false;
        }
        ConflictMetadata other = (ConflictMetadata)obj;
        return Objects.equals(this.filePath(), other.filePath()) && Objects.equals(this.fileSizes(), other.fileSizes()) && Objects.equals(this.fileModes(), other.fileModes()) && Objects.equals(this.objectTypes(), other.objectTypes()) && Objects.equals(this.numberOfConflicts(), other.numberOfConflicts()) && Objects.equals(this.isBinaryFile(), other.isBinaryFile()) && Objects.equals(this.contentConflict(), other.contentConflict()) && Objects.equals(this.fileModeConflict(), other.fileModeConflict()) && Objects.equals(this.objectTypeConflict(), other.objectTypeConflict()) && Objects.equals(this.mergeOperations(), other.mergeOperations());
    }

    public final String toString() {
        return ToString.builder((String)"ConflictMetadata").add("FilePath", (Object)this.filePath()).add("FileSizes", (Object)this.fileSizes()).add("FileModes", (Object)this.fileModes()).add("ObjectTypes", (Object)this.objectTypes()).add("NumberOfConflicts", (Object)this.numberOfConflicts()).add("IsBinaryFile", (Object)this.isBinaryFile()).add("ContentConflict", (Object)this.contentConflict()).add("FileModeConflict", (Object)this.fileModeConflict()).add("ObjectTypeConflict", (Object)this.objectTypeConflict()).add("MergeOperations", (Object)this.mergeOperations()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filePath": {
                return Optional.ofNullable(clazz.cast(this.filePath()));
            }
            case "fileSizes": {
                return Optional.ofNullable(clazz.cast(this.fileSizes()));
            }
            case "fileModes": {
                return Optional.ofNullable(clazz.cast(this.fileModes()));
            }
            case "objectTypes": {
                return Optional.ofNullable(clazz.cast(this.objectTypes()));
            }
            case "numberOfConflicts": {
                return Optional.ofNullable(clazz.cast(this.numberOfConflicts()));
            }
            case "isBinaryFile": {
                return Optional.ofNullable(clazz.cast(this.isBinaryFile()));
            }
            case "contentConflict": {
                return Optional.ofNullable(clazz.cast(this.contentConflict()));
            }
            case "fileModeConflict": {
                return Optional.ofNullable(clazz.cast(this.fileModeConflict()));
            }
            case "objectTypeConflict": {
                return Optional.ofNullable(clazz.cast(this.objectTypeConflict()));
            }
            case "mergeOperations": {
                return Optional.ofNullable(clazz.cast(this.mergeOperations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ConflictMetadata, T> g) {
        return obj -> g.apply((ConflictMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filePath;
        private FileSizes fileSizes;
        private FileModes fileModes;
        private ObjectTypes objectTypes;
        private Integer numberOfConflicts;
        private IsBinaryFile isBinaryFile;
        private Boolean contentConflict;
        private Boolean fileModeConflict;
        private Boolean objectTypeConflict;
        private MergeOperations mergeOperations;

        private BuilderImpl() {
        }

        private BuilderImpl(ConflictMetadata model) {
            this.filePath(model.filePath);
            this.fileSizes(model.fileSizes);
            this.fileModes(model.fileModes);
            this.objectTypes(model.objectTypes);
            this.numberOfConflicts(model.numberOfConflicts);
            this.isBinaryFile(model.isBinaryFile);
            this.contentConflict(model.contentConflict);
            this.fileModeConflict(model.fileModeConflict);
            this.objectTypeConflict(model.objectTypeConflict);
            this.mergeOperations(model.mergeOperations);
        }

        public final String getFilePath() {
            return this.filePath;
        }

        public final void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        @Override
        public final Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public final FileSizes.Builder getFileSizes() {
            return this.fileSizes != null ? this.fileSizes.toBuilder() : null;
        }

        public final void setFileSizes(FileSizes.BuilderImpl fileSizes) {
            this.fileSizes = fileSizes != null ? fileSizes.build() : null;
        }

        @Override
        public final Builder fileSizes(FileSizes fileSizes) {
            this.fileSizes = fileSizes;
            return this;
        }

        public final FileModes.Builder getFileModes() {
            return this.fileModes != null ? this.fileModes.toBuilder() : null;
        }

        public final void setFileModes(FileModes.BuilderImpl fileModes) {
            this.fileModes = fileModes != null ? fileModes.build() : null;
        }

        @Override
        public final Builder fileModes(FileModes fileModes) {
            this.fileModes = fileModes;
            return this;
        }

        public final ObjectTypes.Builder getObjectTypes() {
            return this.objectTypes != null ? this.objectTypes.toBuilder() : null;
        }

        public final void setObjectTypes(ObjectTypes.BuilderImpl objectTypes) {
            this.objectTypes = objectTypes != null ? objectTypes.build() : null;
        }

        @Override
        public final Builder objectTypes(ObjectTypes objectTypes) {
            this.objectTypes = objectTypes;
            return this;
        }

        public final Integer getNumberOfConflicts() {
            return this.numberOfConflicts;
        }

        public final void setNumberOfConflicts(Integer numberOfConflicts) {
            this.numberOfConflicts = numberOfConflicts;
        }

        @Override
        public final Builder numberOfConflicts(Integer numberOfConflicts) {
            this.numberOfConflicts = numberOfConflicts;
            return this;
        }

        public final IsBinaryFile.Builder getIsBinaryFile() {
            return this.isBinaryFile != null ? this.isBinaryFile.toBuilder() : null;
        }

        public final void setIsBinaryFile(IsBinaryFile.BuilderImpl isBinaryFile) {
            this.isBinaryFile = isBinaryFile != null ? isBinaryFile.build() : null;
        }

        @Override
        public final Builder isBinaryFile(IsBinaryFile isBinaryFile) {
            this.isBinaryFile = isBinaryFile;
            return this;
        }

        public final Boolean getContentConflict() {
            return this.contentConflict;
        }

        public final void setContentConflict(Boolean contentConflict) {
            this.contentConflict = contentConflict;
        }

        @Override
        public final Builder contentConflict(Boolean contentConflict) {
            this.contentConflict = contentConflict;
            return this;
        }

        public final Boolean getFileModeConflict() {
            return this.fileModeConflict;
        }

        public final void setFileModeConflict(Boolean fileModeConflict) {
            this.fileModeConflict = fileModeConflict;
        }

        @Override
        public final Builder fileModeConflict(Boolean fileModeConflict) {
            this.fileModeConflict = fileModeConflict;
            return this;
        }

        public final Boolean getObjectTypeConflict() {
            return this.objectTypeConflict;
        }

        public final void setObjectTypeConflict(Boolean objectTypeConflict) {
            this.objectTypeConflict = objectTypeConflict;
        }

        @Override
        public final Builder objectTypeConflict(Boolean objectTypeConflict) {
            this.objectTypeConflict = objectTypeConflict;
            return this;
        }

        public final MergeOperations.Builder getMergeOperations() {
            return this.mergeOperations != null ? this.mergeOperations.toBuilder() : null;
        }

        public final void setMergeOperations(MergeOperations.BuilderImpl mergeOperations) {
            this.mergeOperations = mergeOperations != null ? mergeOperations.build() : null;
        }

        @Override
        public final Builder mergeOperations(MergeOperations mergeOperations) {
            this.mergeOperations = mergeOperations;
            return this;
        }

        public ConflictMetadata build() {
            return new ConflictMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConflictMetadata> {
        public Builder filePath(String var1);

        public Builder fileSizes(FileSizes var1);

        default public Builder fileSizes(Consumer<FileSizes.Builder> fileSizes) {
            return this.fileSizes((FileSizes)((FileSizes.Builder)FileSizes.builder().applyMutation(fileSizes)).build());
        }

        public Builder fileModes(FileModes var1);

        default public Builder fileModes(Consumer<FileModes.Builder> fileModes) {
            return this.fileModes((FileModes)((FileModes.Builder)FileModes.builder().applyMutation(fileModes)).build());
        }

        public Builder objectTypes(ObjectTypes var1);

        default public Builder objectTypes(Consumer<ObjectTypes.Builder> objectTypes) {
            return this.objectTypes((ObjectTypes)((ObjectTypes.Builder)ObjectTypes.builder().applyMutation(objectTypes)).build());
        }

        public Builder numberOfConflicts(Integer var1);

        public Builder isBinaryFile(IsBinaryFile var1);

        default public Builder isBinaryFile(Consumer<IsBinaryFile.Builder> isBinaryFile) {
            return this.isBinaryFile((IsBinaryFile)((IsBinaryFile.Builder)IsBinaryFile.builder().applyMutation(isBinaryFile)).build());
        }

        public Builder contentConflict(Boolean var1);

        public Builder fileModeConflict(Boolean var1);

        public Builder objectTypeConflict(Boolean var1);

        public Builder mergeOperations(MergeOperations var1);

        default public Builder mergeOperations(Consumer<MergeOperations.Builder> mergeOperations) {
            return this.mergeOperations((MergeOperations)((MergeOperations.Builder)MergeOperations.builder().applyMutation(mergeOperations)).build());
        }
    }
}

