/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.ApprovalRuleTemplateNameListCopier;
import software.amazon.awssdk.services.codecommit.model.CodeCommitResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAssociatedApprovalRuleTemplatesForRepositoryResponse
extends CodeCommitResponse
implements ToCopyableBuilder<Builder, ListAssociatedApprovalRuleTemplatesForRepositoryResponse> {
    private static final SdkField<List<String>> APPROVAL_RULE_TEMPLATE_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("approvalRuleTemplateNames").getter(ListAssociatedApprovalRuleTemplatesForRepositoryResponse.getter(ListAssociatedApprovalRuleTemplatesForRepositoryResponse::approvalRuleTemplateNames)).setter(ListAssociatedApprovalRuleTemplatesForRepositoryResponse.setter(Builder::approvalRuleTemplateNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleTemplateNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListAssociatedApprovalRuleTemplatesForRepositoryResponse.getter(ListAssociatedApprovalRuleTemplatesForRepositoryResponse::nextToken)).setter(ListAssociatedApprovalRuleTemplatesForRepositoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPROVAL_RULE_TEMPLATE_NAMES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAssociatedApprovalRuleTemplatesForRepositoryResponse.memberNameToFieldInitializer();
    private final List<String> approvalRuleTemplateNames;
    private final String nextToken;

    private ListAssociatedApprovalRuleTemplatesForRepositoryResponse(BuilderImpl builder) {
        super(builder);
        this.approvalRuleTemplateNames = builder.approvalRuleTemplateNames;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasApprovalRuleTemplateNames() {
        return this.approvalRuleTemplateNames != null && !(this.approvalRuleTemplateNames instanceof SdkAutoConstructList);
    }

    public final List<String> approvalRuleTemplateNames() {
        return this.approvalRuleTemplateNames;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApprovalRuleTemplateNames() ? this.approvalRuleTemplateNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAssociatedApprovalRuleTemplatesForRepositoryResponse)) {
            return false;
        }
        ListAssociatedApprovalRuleTemplatesForRepositoryResponse other = (ListAssociatedApprovalRuleTemplatesForRepositoryResponse)((Object)obj);
        return this.hasApprovalRuleTemplateNames() == other.hasApprovalRuleTemplateNames() && Objects.equals(this.approvalRuleTemplateNames(), other.approvalRuleTemplateNames()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAssociatedApprovalRuleTemplatesForRepositoryResponse").add("ApprovalRuleTemplateNames", this.hasApprovalRuleTemplateNames() ? this.approvalRuleTemplateNames() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "approvalRuleTemplateNames": {
                return Optional.ofNullable(clazz.cast(this.approvalRuleTemplateNames()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("approvalRuleTemplateNames", APPROVAL_RULE_TEMPLATE_NAMES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAssociatedApprovalRuleTemplatesForRepositoryResponse, T> g) {
        return obj -> g.apply((ListAssociatedApprovalRuleTemplatesForRepositoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeCommitResponse.BuilderImpl
    implements Builder {
        private List<String> approvalRuleTemplateNames = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAssociatedApprovalRuleTemplatesForRepositoryResponse model) {
            super(model);
            this.approvalRuleTemplateNames(model.approvalRuleTemplateNames);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getApprovalRuleTemplateNames() {
            if (this.approvalRuleTemplateNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.approvalRuleTemplateNames;
        }

        public final void setApprovalRuleTemplateNames(Collection<String> approvalRuleTemplateNames) {
            this.approvalRuleTemplateNames = ApprovalRuleTemplateNameListCopier.copy(approvalRuleTemplateNames);
        }

        @Override
        public final Builder approvalRuleTemplateNames(Collection<String> approvalRuleTemplateNames) {
            this.approvalRuleTemplateNames = ApprovalRuleTemplateNameListCopier.copy(approvalRuleTemplateNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvalRuleTemplateNames(String ... approvalRuleTemplateNames) {
            this.approvalRuleTemplateNames(Arrays.asList(approvalRuleTemplateNames));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAssociatedApprovalRuleTemplatesForRepositoryResponse build() {
            return new ListAssociatedApprovalRuleTemplatesForRepositoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CodeCommitResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAssociatedApprovalRuleTemplatesForRepositoryResponse> {
        public Builder approvalRuleTemplateNames(Collection<String> var1);

        public Builder approvalRuleTemplateNames(String ... var1);

        public Builder nextToken(String var1);
    }
}

