/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codecommit.model.ParentListCopier;
import software.amazon.awssdk.services.codecommit.model.UserInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Commit
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Commit> {
    private static final SdkField<String> COMMIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("commitId").getter(Commit.getter(Commit::commitId)).setter(Commit.setter(Builder::commitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("commitId").build()}).build();
    private static final SdkField<String> TREE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("treeId").getter(Commit.getter(Commit::treeId)).setter(Commit.setter(Builder::treeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("treeId").build()}).build();
    private static final SdkField<List<String>> PARENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("parents").getter(Commit.getter(Commit::parents)).setter(Commit.setter(Builder::parents)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parents").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(Commit.getter(Commit::message)).setter(Commit.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<UserInfo> AUTHOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("author").getter(Commit.getter(Commit::author)).setter(Commit.setter(Builder::author)).constructor(UserInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("author").build()}).build();
    private static final SdkField<UserInfo> COMMITTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("committer").getter(Commit.getter(Commit::committer)).setter(Commit.setter(Builder::committer)).constructor(UserInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("committer").build()}).build();
    private static final SdkField<String> ADDITIONAL_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("additionalData").getter(Commit.getter(Commit::additionalData)).setter(Commit.setter(Builder::additionalData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalData").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMIT_ID_FIELD, TREE_ID_FIELD, PARENTS_FIELD, MESSAGE_FIELD, AUTHOR_FIELD, COMMITTER_FIELD, ADDITIONAL_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Commit.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String commitId;
    private final String treeId;
    private final List<String> parents;
    private final String message;
    private final UserInfo author;
    private final UserInfo committer;
    private final String additionalData;

    private Commit(BuilderImpl builder) {
        this.commitId = builder.commitId;
        this.treeId = builder.treeId;
        this.parents = builder.parents;
        this.message = builder.message;
        this.author = builder.author;
        this.committer = builder.committer;
        this.additionalData = builder.additionalData;
    }

    public final String commitId() {
        return this.commitId;
    }

    public final String treeId() {
        return this.treeId;
    }

    public final boolean hasParents() {
        return this.parents != null && !(this.parents instanceof SdkAutoConstructList);
    }

    public final List<String> parents() {
        return this.parents;
    }

    public final String message() {
        return this.message;
    }

    public final UserInfo author() {
        return this.author;
    }

    public final UserInfo committer() {
        return this.committer;
    }

    public final String additionalData() {
        return this.additionalData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.commitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.treeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParents() ? this.parents() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.author());
        hashCode = 31 * hashCode + Objects.hashCode(this.committer());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalData());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Commit)) {
            return false;
        }
        Commit other = (Commit)obj;
        return Objects.equals(this.commitId(), other.commitId()) && Objects.equals(this.treeId(), other.treeId()) && this.hasParents() == other.hasParents() && Objects.equals(this.parents(), other.parents()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.author(), other.author()) && Objects.equals(this.committer(), other.committer()) && Objects.equals(this.additionalData(), other.additionalData());
    }

    public final String toString() {
        return ToString.builder((String)"Commit").add("CommitId", (Object)this.commitId()).add("TreeId", (Object)this.treeId()).add("Parents", this.hasParents() ? this.parents() : null).add("Message", (Object)this.message()).add("Author", (Object)this.author()).add("Committer", (Object)this.committer()).add("AdditionalData", (Object)this.additionalData()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "commitId": {
                return Optional.ofNullable(clazz.cast(this.commitId()));
            }
            case "treeId": {
                return Optional.ofNullable(clazz.cast(this.treeId()));
            }
            case "parents": {
                return Optional.ofNullable(clazz.cast(this.parents()));
            }
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "author": {
                return Optional.ofNullable(clazz.cast(this.author()));
            }
            case "committer": {
                return Optional.ofNullable(clazz.cast(this.committer()));
            }
            case "additionalData": {
                return Optional.ofNullable(clazz.cast(this.additionalData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("commitId", COMMIT_ID_FIELD);
        map.put("treeId", TREE_ID_FIELD);
        map.put("parents", PARENTS_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("author", AUTHOR_FIELD);
        map.put("committer", COMMITTER_FIELD);
        map.put("additionalData", ADDITIONAL_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Commit, T> g) {
        return obj -> g.apply((Commit)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String commitId;
        private String treeId;
        private List<String> parents = DefaultSdkAutoConstructList.getInstance();
        private String message;
        private UserInfo author;
        private UserInfo committer;
        private String additionalData;

        private BuilderImpl() {
        }

        private BuilderImpl(Commit model) {
            this.commitId(model.commitId);
            this.treeId(model.treeId);
            this.parents(model.parents);
            this.message(model.message);
            this.author(model.author);
            this.committer(model.committer);
            this.additionalData(model.additionalData);
        }

        public final String getCommitId() {
            return this.commitId;
        }

        public final void setCommitId(String commitId) {
            this.commitId = commitId;
        }

        @Override
        public final Builder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public final String getTreeId() {
            return this.treeId;
        }

        public final void setTreeId(String treeId) {
            this.treeId = treeId;
        }

        @Override
        public final Builder treeId(String treeId) {
            this.treeId = treeId;
            return this;
        }

        public final Collection<String> getParents() {
            if (this.parents instanceof SdkAutoConstructList) {
                return null;
            }
            return this.parents;
        }

        public final void setParents(Collection<String> parents) {
            this.parents = ParentListCopier.copy(parents);
        }

        @Override
        public final Builder parents(Collection<String> parents) {
            this.parents = ParentListCopier.copy(parents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parents(String ... parents) {
            this.parents(Arrays.asList(parents));
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final UserInfo.Builder getAuthor() {
            return this.author != null ? this.author.toBuilder() : null;
        }

        public final void setAuthor(UserInfo.BuilderImpl author) {
            this.author = author != null ? author.build() : null;
        }

        @Override
        public final Builder author(UserInfo author) {
            this.author = author;
            return this;
        }

        public final UserInfo.Builder getCommitter() {
            return this.committer != null ? this.committer.toBuilder() : null;
        }

        public final void setCommitter(UserInfo.BuilderImpl committer) {
            this.committer = committer != null ? committer.build() : null;
        }

        @Override
        public final Builder committer(UserInfo committer) {
            this.committer = committer;
            return this;
        }

        public final String getAdditionalData() {
            return this.additionalData;
        }

        public final void setAdditionalData(String additionalData) {
            this.additionalData = additionalData;
        }

        @Override
        public final Builder additionalData(String additionalData) {
            this.additionalData = additionalData;
            return this;
        }

        public Commit build() {
            return new Commit(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Commit> {
        public Builder commitId(String var1);

        public Builder treeId(String var1);

        public Builder parents(Collection<String> var1);

        public Builder parents(String ... var1);

        public Builder message(String var1);

        public Builder author(UserInfo var1);

        default public Builder author(Consumer<UserInfo.Builder> author) {
            return this.author((UserInfo)((UserInfo.Builder)UserInfo.builder().applyMutation(author)).build());
        }

        public Builder committer(UserInfo var1);

        default public Builder committer(Consumer<UserInfo.Builder> committer) {
            return this.committer((UserInfo)((UserInfo.Builder)UserInfo.builder().applyMutation(committer)).build());
        }

        public Builder additionalData(String var1);
    }
}

