/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codecommit.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateApprovalRuleTemplateWithRepositoryRequest extends CodeCommitRequest
        implements
        ToCopyableBuilder<AssociateApprovalRuleTemplateWithRepositoryRequest.Builder, AssociateApprovalRuleTemplateWithRepositoryRequest> {
    private static final SdkField<String> APPROVAL_RULE_TEMPLATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("approvalRuleTemplateName")
            .getter(getter(AssociateApprovalRuleTemplateWithRepositoryRequest::approvalRuleTemplateName))
            .setter(setter(Builder::approvalRuleTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRuleTemplateName").build())
            .build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(AssociateApprovalRuleTemplateWithRepositoryRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            APPROVAL_RULE_TEMPLATE_NAME_FIELD, REPOSITORY_NAME_FIELD));

    private final String approvalRuleTemplateName;

    private final String repositoryName;

    private AssociateApprovalRuleTemplateWithRepositoryRequest(BuilderImpl builder) {
        super(builder);
        this.approvalRuleTemplateName = builder.approvalRuleTemplateName;
        this.repositoryName = builder.repositoryName;
    }

    /**
     * <p>
     * The name for the approval rule template.
     * </p>
     * 
     * @return The name for the approval rule template.
     */
    public final String approvalRuleTemplateName() {
        return approvalRuleTemplateName;
    }

    /**
     * <p>
     * The name of the repository that you want to associate with the template.
     * </p>
     * 
     * @return The name of the repository that you want to associate with the template.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(approvalRuleTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateApprovalRuleTemplateWithRepositoryRequest)) {
            return false;
        }
        AssociateApprovalRuleTemplateWithRepositoryRequest other = (AssociateApprovalRuleTemplateWithRepositoryRequest) obj;
        return Objects.equals(approvalRuleTemplateName(), other.approvalRuleTemplateName())
                && Objects.equals(repositoryName(), other.repositoryName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateApprovalRuleTemplateWithRepositoryRequest")
                .add("ApprovalRuleTemplateName", approvalRuleTemplateName()).add("RepositoryName", repositoryName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "approvalRuleTemplateName":
            return Optional.ofNullable(clazz.cast(approvalRuleTemplateName()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateApprovalRuleTemplateWithRepositoryRequest, T> g) {
        return obj -> g.apply((AssociateApprovalRuleTemplateWithRepositoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeCommitRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateApprovalRuleTemplateWithRepositoryRequest> {
        /**
         * <p>
         * The name for the approval rule template.
         * </p>
         * 
         * @param approvalRuleTemplateName
         *        The name for the approval rule template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRuleTemplateName(String approvalRuleTemplateName);

        /**
         * <p>
         * The name of the repository that you want to associate with the template.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository that you want to associate with the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeCommitRequest.BuilderImpl implements Builder {
        private String approvalRuleTemplateName;

        private String repositoryName;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateApprovalRuleTemplateWithRepositoryRequest model) {
            super(model);
            approvalRuleTemplateName(model.approvalRuleTemplateName);
            repositoryName(model.repositoryName);
        }

        public final String getApprovalRuleTemplateName() {
            return approvalRuleTemplateName;
        }

        public final void setApprovalRuleTemplateName(String approvalRuleTemplateName) {
            this.approvalRuleTemplateName = approvalRuleTemplateName;
        }

        @Override
        public final Builder approvalRuleTemplateName(String approvalRuleTemplateName) {
            this.approvalRuleTemplateName = approvalRuleTemplateName;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateApprovalRuleTemplateWithRepositoryRequest build() {
            return new AssociateApprovalRuleTemplateWithRepositoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
