/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codecommit.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codecommit.CodeCommitAsyncClient;
import software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesRequest;
import software.amazon.awssdk.services.codecommit.model.ListApprovalRuleTemplatesResponse;

public class ListApprovalRuleTemplatesPublisher
implements SdkPublisher<ListApprovalRuleTemplatesResponse> {
    private final CodeCommitAsyncClient client;
    private final ListApprovalRuleTemplatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApprovalRuleTemplatesPublisher(CodeCommitAsyncClient client, ListApprovalRuleTemplatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApprovalRuleTemplatesPublisher(CodeCommitAsyncClient client, ListApprovalRuleTemplatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApprovalRuleTemplatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApprovalRuleTemplatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListApprovalRuleTemplatesResponseFetcher
    implements AsyncPageFetcher<ListApprovalRuleTemplatesResponse> {
        private ListApprovalRuleTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(ListApprovalRuleTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApprovalRuleTemplatesResponse> nextPage(ListApprovalRuleTemplatesResponse previousPage) {
            if (previousPage == null) {
                return ListApprovalRuleTemplatesPublisher.this.client.listApprovalRuleTemplates(ListApprovalRuleTemplatesPublisher.this.firstRequest);
            }
            return ListApprovalRuleTemplatesPublisher.this.client.listApprovalRuleTemplates((ListApprovalRuleTemplatesRequest)((Object)ListApprovalRuleTemplatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

